/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentCustomizationDetector;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentTree;
import org.xwiki.extension.xar.internal.event.XarExtensionInstalledEvent;
import org.xwiki.extension.xar.internal.event.XarExtensionUninstalledEvent;
import org.xwiki.extension.xar.internal.event.XarExtensionUpgradedEvent;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="InstalledExtensionDocumentListener")
@Singleton
public class InstalledExtensionDocumentListener
extends AbstractEventListener {
    public static final String HINT = "InstalledExtensionDocumentListener";
    @Inject
    private Logger logger;
    @Inject
    private InstalledExtensionDocumentTree tree;
    @Inject
    private Provider<Packager> packagerProvider;
    @Inject
    @Named(value="xar")
    private Provider<InstalledExtensionRepository> xarRepositoryProvider;
    @Inject
    private Provider<InstalledExtensionDocumentCustomizationDetector> customizationDetectorProvider;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;

    public InstalledExtensionDocumentListener() {
        super(HINT, new Event[]{new ApplicationReadyEvent(), new WikiReadyEvent(), new DocumentUpdatedEvent(), new XarExtensionInstalledEvent(), new XarExtensionUpgradedEvent(), new XarExtensionUninstalledEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof DocumentUpdatedEvent) {
            XWikiDocument document = (XWikiDocument)source;
            if (this.tree.isExtensionPage(document.getDocumentReference())) {
                this.updateCustomizedFlag(document.getDocumentReferenceWithLocale());
            }
        } else if (event instanceof ApplicationReadyEvent) {
            this.addExtensionDocuments(((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getCurrentWikiId());
        } else if (event instanceof WikiReadyEvent) {
            this.addExtensionDocuments((String)source);
        } else if (event instanceof XarExtensionInstalledEvent) {
            this.addExtensionDocuments((ExtensionEvent)event, (InstalledExtension)source);
        } else if (event instanceof XarExtensionUninstalledEvent) {
            this.removeExtensionDocuments((ExtensionEvent)event, (InstalledExtension)source);
        } else if (event instanceof XarExtensionUpgradedEvent) {
            ((Collection)data).stream().forEach(oldInstalledExtension -> this.removeExtensionDocuments((ExtensionEvent)event, (InstalledExtension)oldInstalledExtension));
            this.addExtensionDocuments((ExtensionEvent)event, (InstalledExtension)source);
        }
    }

    private void updateCustomizedFlag(DocumentReference documentReferenceWithLocale) {
        this.tree.setCustomizedExtensionPage(documentReferenceWithLocale, ((InstalledExtensionDocumentCustomizationDetector)this.customizationDetectorProvider.get()).isCustomized(documentReferenceWithLocale));
    }

    private void addExtensionDocuments(String wiki) {
        String namespace = "wiki:" + wiki;
        ((InstalledExtensionRepository)this.xarRepositoryProvider.get()).getInstalledExtensions(namespace).stream().forEach(installedExtension -> this.addExtensionDocuments(new XarExtensionInstalledEvent(new ExtensionInstalledEvent(installedExtension.getId(), namespace)), (InstalledExtension)installedExtension));
    }

    private void addExtensionDocuments(ExtensionEvent extensionEvent, InstalledExtension installedExtension) {
        this.forEachExtensionDocument(extensionEvent, installedExtension, this::addExtensionDocument);
    }

    private void addExtensionDocument(DocumentReference documentReference) {
        this.tree.addExtensionPage(this.withoutLocale(documentReference));
        this.updateCustomizedFlag(documentReference);
    }

    private void removeExtensionDocuments(ExtensionEvent extensionEvent, InstalledExtension installedExtension) {
        this.forEachExtensionDocument(extensionEvent, installedExtension, this::removeExtensionDocument);
    }

    private void forEachExtensionDocument(ExtensionEvent extensionEvent, InstalledExtension installedExtension, Consumer<DocumentReference> action) {
        if (extensionEvent.hasNamespace() && installedExtension instanceof XarInstalledExtension) {
            this.getExtensionDocuments((XarInstalledExtension)installedExtension, extensionEvent.getNamespace()).stream().forEach(action);
        }
    }

    private void removeExtensionDocument(DocumentReference documentReference) {
        if (this.getXarInstalledExtensions(documentReference).isEmpty()) {
            this.tree.removeExtensionPage(this.withoutLocale(documentReference));
        } else {
            this.updateCustomizedFlag(documentReference);
        }
    }

    private DocumentReference withoutLocale(DocumentReference documentReference) {
        return new DocumentReference((EntityReference)documentReference, (Locale)null);
    }

    private Collection<XarInstalledExtension> getXarInstalledExtensions(DocumentReference documentReference) {
        return ((XarInstalledExtensionRepository)((Object)this.xarRepositoryProvider.get())).getXarInstalledExtensions(documentReference);
    }

    private Set<DocumentReference> getExtensionDocuments(XarInstalledExtension xarInstalledExtension, String namespace) {
        try {
            PackageConfiguration configuration = new PackageConfiguration();
            configuration.setWiki(XarHandlerUtils.getWikiFromNamespace(namespace));
            return new HashSet<DocumentReference>(((Packager)this.packagerProvider.get()).getDocumentReferences(xarInstalledExtension.getXarPackage().getEntries(), configuration));
        }
        catch (UnsupportedNamespaceException e) {
            this.logger.warn("Unsupported namespace [{}].", (Object)namespace);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve the list of documents from the XAR package [{}].", (Object)xarInstalledExtension.getId(), (Object)e);
        }
        return Collections.emptySet();
    }
}

