/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.job.diff.DocumentUnifiedDiffBuilder;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.job.diff.DocumentUnifiedDiff;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.xar.XarException;

@Component(roles={InstalledExtensionDocumentCustomizationDetector.class})
@Singleton
public class InstalledExtensionDocumentCustomizationDetector {
    @Inject
    private Logger logger;
    @Inject
    private DocumentUnifiedDiffBuilder documentDiffBuilder;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedXARs;

    public boolean isCustomized(DocumentReference documentReferenceWithLocale) {
        Collection<XarInstalledExtension> installedExtensions = ((XarInstalledExtensionRepository)this.installedXARs).getXarInstalledExtensions(documentReferenceWithLocale);
        return installedExtensions.stream().allMatch(installedExtension -> this.isCustomized(documentReferenceWithLocale, (XarInstalledExtension)((Object)installedExtension)));
    }

    private boolean isCustomized(DocumentReference documentReferenceWithLocale, XarInstalledExtension installedExtension) {
        XWikiDocument docFromDB;
        XWikiDocument docFromXAR = this.getDocumentFromXAR(documentReferenceWithLocale, installedExtension);
        DocumentUnifiedDiff documentDiff = this.documentDiffBuilder.diff(docFromXAR, docFromDB = this.getDocumentFromDatabase(documentReferenceWithLocale));
        return !documentDiff.isEmpty() || !documentDiff.getAttachmentDiffs().isEmpty() || !documentDiff.getObjectDiffs().isEmpty() || !documentDiff.getClassPropertyDiffs().isEmpty();
    }

    private XWikiDocument getDocumentFromXAR(DocumentReference documentReferenceWithLocale, XarInstalledExtension installedExtension) {
        try {
            return this.packager.getXWikiDocument(documentReferenceWithLocale, installedExtension);
        }
        catch (IOException | XarException e) {
            this.logger.error("Failed to get document [{}] from XAR [{}].", new Object[]{documentReferenceWithLocale, installedExtension.getId(), e});
            return null;
        }
    }

    private XWikiDocument getDocumentFromDatabase(DocumentReference documentReferenceWithLocale) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(documentReferenceWithLocale, xcontext);
            if (!document.isNew()) {
                return document;
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get document [{}] from database.", (Object)documentReferenceWithLocale, (Object)e);
        }
        return null;
    }
}

