/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.delete.question;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.extension.xar.internal.delete.question.ExtensionSelection;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.job.question.EntitySelection;

public class ExtensionBreakingQuestion {
    private Map<EntityReference, EntitySelection> concernedEntities;
    private Map<String, ExtensionSelection> extensions = new HashMap<String, ExtensionSelection>();
    private List<EntitySelection> freePages = new ArrayList<EntitySelection>();

    public ExtensionBreakingQuestion(Map<EntityReference, EntitySelection> concernedEntities) {
        this.concernedEntities = concernedEntities;
    }

    public EntitySelection get(EntityReference entityReference) {
        return this.concernedEntities.get(entityReference);
    }

    public Map<EntityReference, EntitySelection> getConcernedEntities() {
        return this.concernedEntities;
    }

    public Map<String, ExtensionSelection> getExtensions() {
        return this.extensions;
    }

    public List<EntitySelection> getFreePages() {
        return this.freePages;
    }

    public void selectAllExtensions() {
        for (ExtensionSelection extension : this.extensions.values()) {
            extension.selectAllPages();
        }
    }

    public void setSelectAllExtensions(boolean select) {
        if (select) {
            this.selectAllExtensions();
        }
    }

    public void selectAllFreePages() {
        for (EntitySelection entitySelection : this.freePages) {
            entitySelection.setSelected(true);
        }
    }

    public void setSelectAllFreePages(boolean select) {
        if (select) {
            this.selectAllFreePages();
        }
    }

    public void markAsFreePage(EntitySelection entitySelection) {
        this.freePages.add(entitySelection);
    }

    public void pageBelongsToExtension(EntitySelection entitySelection, XarInstalledExtension extension) {
        ExtensionSelection extensionSelection = this.getExtension(extension.getId().getId());
        if (extensionSelection == null) {
            extensionSelection = new ExtensionSelection(extension);
            this.extensions.put(extension.getId().getId(), extensionSelection);
        }
        extensionSelection.addPage(entitySelection);
    }

    public ExtensionSelection getExtension(String extensionId) {
        return this.extensions.get(extensionId);
    }

    public void unselectAll() {
        for (EntitySelection entitySelection : this.concernedEntities.values()) {
            if (entitySelection.getState() != EntitySelection.State.UNKNOWN) continue;
            entitySelection.setSelected(false);
        }
    }

    public void setSelectedExtensions(Set<String> extensionIds) {
        for (String extensionId : extensionIds) {
            ExtensionSelection extensionSelection = this.getExtension(extensionId);
            if (extensionSelection == null) continue;
            extensionSelection.selectAllPages();
        }
    }

    public void setSelectedDocuments(Set<DocumentReference> documents) {
        for (DocumentReference document : documents) {
            EntitySelection entitySelection = this.concernedEntities.get(document);
            if (entitySelection == null) continue;
            entitySelection.setSelected(true);
        }
    }
}

