/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.ExpressionNodeToHQLConverter;
import org.xwiki.notifications.sources.internal.QueryExpressionGenerator;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={QueryGenerator.class})
@Singleton
public class QueryGenerator {
    @Inject
    private QueryManager queryManager;
    @Inject
    private QueryExpressionGenerator expressionGenerator;
    @Inject
    private ExpressionNodeToHQLConverter hqlConverter;

    public Query generateQuery(NotificationParameters parameters) throws QueryException, EventStreamException {
        ExpressionNodeToHQLConverter.HQLQuery result = this.hqlConverter.parse(this.expressionGenerator.generateQueryExpression(parameters));
        if (result.getQuery().isEmpty()) {
            return null;
        }
        Query query = this.queryManager.createQuery(String.format("where %s", result.getQuery()), "hql");
        for (Map.Entry<String, Object> queryParameter : result.getQueryParameters().entrySet()) {
            query.bindValue(queryParameter.getKey(), queryParameter.getValue());
        }
        return query;
    }

    public ExpressionNode generateQueryExpression(NotificationParameters parameters) throws EventStreamException {
        return this.expressionGenerator.generateQueryExpression(parameters);
    }
}

