/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.EventSearcher;
import org.xwiki.notifications.sources.internal.QueryGenerator;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;

@Component(roles={EventSearcher.class})
@Singleton
public class LegacyEventSearcher
extends EventSearcher {
    @Inject
    private EventStream eventStream;
    @Inject
    private QueryGenerator queryGenerator;

    public List<Event> searchEvents(int offset, int limit, NotificationParameters parameters) throws QueryException, EventStreamException {
        if (this.configuration.isEventStoreEnabled()) {
            try {
                return super.searchEvents(offset, limit, parameters);
            }
            catch (EventStreamException e) {
                this.logger.warn("Failed to get events from the EventStore. Reason: [{}]. Trying the legacy store.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return this.searchStreamEvents(offset, limit, parameters);
    }

    public List<Event> searchStreamEvents(int offset, int limit, NotificationParameters parameters) throws QueryException, EventStreamException {
        Query query = this.queryGenerator.generateQuery(parameters);
        if (query == null) {
            return Collections.emptyList();
        }
        query.setLimit(limit).setOffset(offset);
        return this.eventStream.searchEvents(query);
    }
}

