/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.store.internal.EventStreamWikiCleanerJobRequest;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="EventStreamWikiDeletedEventListener")
@Singleton
public class WikiDeletedListener
extends AbstractEventListener {
    public static final String NAME = "EventStreamWikiDeletedEventListener";
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private Logger logger;

    public WikiDeletedListener() {
        super(NAME, new Event[]{new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        WikiDeletedEvent wikiDeletedEvent = (WikiDeletedEvent)event;
        try {
            EventStreamWikiCleanerJobRequest request = new EventStreamWikiCleanerJobRequest(wikiDeletedEvent.getWikiId());
            request.setId(Arrays.asList("EventStreamWikiCleanerJob", wikiDeletedEvent.getWikiId()));
            this.jobExecutor.execute("EventStreamWikiCleanerJob", (Request)request);
        }
        catch (Exception e) {
            this.logger.error("Failed to start a job [EventStreamWikiCleanerJob] for the deleted wiki [{}]", (Object)wikiDeletedEvent.getWikiId(), (Object)e);
        }
    }
}

