/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventGroup;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.store.internal.LegacyEventDeleter;
import org.xwiki.eventstream.store.internal.LegacyEventLoader;
import org.xwiki.eventstream.store.internal.LegacyEventSaver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;

@Component
@Singleton
public class LegacyEventStream
implements EventStream {
    @Inject
    private LegacyEventLoader legacyEventLoader;
    @Inject
    private LegacyEventSaver legacyEventSaver;
    @Inject
    private LegacyEventDeleter legacyEventDeleter;

    @Override
    public void addEvent(Event event) {
        this.legacyEventSaver.saveEvent(event);
    }

    @Override
    public void deleteEvent(Event event) {
        this.legacyEventDeleter.deleteEvent(event);
    }

    @Override
    public EventGroup getRelatedEvents(Event event) {
        return this.legacyEventLoader.getRelatedEvents(event);
    }

    @Override
    public List<Event> searchEvents(Query query) throws QueryException {
        return this.legacyEventLoader.searchEvents(query);
    }

    @Override
    public Event getEvent(String eventId) throws QueryException {
        return this.legacyEventLoader.getEvent(eventId);
    }

    @Override
    public long countEvents() throws QueryException {
        return this.legacyEventLoader.countEvents();
    }
}

