/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.XWikiHibernateStore;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.store.internal.LegacyEvent;
import org.xwiki.eventstream.store.internal.LegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={LegacyEventSaver.class})
@Singleton
public class LegacyEventSaver {
    @Inject
    private LegacyEventConverter eventConverter;
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;

    public void saveEvent(Event event) {
        LegacyEvent legacyEvent = this.eventConverter.convertEventToLegacyActivity(event);
        try {
            boolean isSavedOnMainStore = false;
            if (this.configuration.useLocalStore()) {
                this.saveLegacyEvent(legacyEvent, legacyEvent.getWiki());
                isSavedOnMainStore = this.wikiDescriptorManager.isMainWiki(legacyEvent.getWiki());
            }
            if (this.configuration.useMainStore() && !isSavedOnMainStore) {
                this.saveLegacyEvent(legacyEvent, this.wikiDescriptorManager.getMainWikiId());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to save an event in the event stream.", (Throwable)e);
        }
    }

    private void saveLegacyEvent(LegacyEvent event, String wikiId) throws Exception {
        this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            hibernateStore.executeWrite(context, session -> session.save((Object)event));
            return null;
        });
    }
}

