/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventGroup;
import org.xwiki.eventstream.store.internal.LegacyEvent;
import org.xwiki.eventstream.store.internal.LegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={LegacyEventLoader.class})
@Singleton
public class LegacyEventLoader {
    @Inject
    private QueryManager queryManager;
    @Inject
    private LegacyEventConverter eventConverter;
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    public EventGroup getRelatedEvents(Event event) {
        EventGroup result = new EventGroup();
        try {
            Query query = this.queryManager.createQuery("where event.requestId = :requestId", "hql");
            query.bindValue("requestId", (Object)event.getGroupId());
            List<Event> events = this.searchEvents(query);
            result.addEvents(events.toArray(new Event[0]));
        }
        catch (Exception e) {
            this.logger.error("Failed to load related events for [%s].", (Object)event.getId(), (Object)e);
        }
        return result;
    }

    public List<Event> searchEvents(Query query) throws QueryException {
        Query q = this.queryManager.createQuery("select event from LegacyEvent event " + query.getStatement(), query.getLanguage());
        for (Map.Entry entry : query.getNamedParameters().entrySet()) {
            q.bindValue((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : query.getPositionalParameters().entrySet()) {
            q.bindValue(((Integer)entry.getKey()).intValue(), entry.getValue());
        }
        q.setLimit(query.getLimit());
        q.setOffset(query.getOffset());
        if (this.configuration.useMainStore()) {
            q.setWiki(this.wikiDescriptorManager.getMainWikiId());
        }
        List events = q.execute();
        return this.convertActivitiesToEvents(events);
    }

    private List<Event> convertActivitiesToEvents(List<LegacyEvent> events) {
        ArrayList<Event> result = new ArrayList<Event>(events.size());
        for (LegacyEvent e : events) {
            result.add(this.eventConverter.convertLegacyActivityToEvent(e));
        }
        return result;
    }

    public LegacyEvent getLegacyEvent(String eventId) throws QueryException {
        List events;
        Query query = this.queryManager.createQuery("select event from LegacyEvent event where eventId = :eventId", "hql");
        query.bindValue("eventId", (Object)eventId);
        if (this.configuration.useMainStore()) {
            query.setWiki(this.wikiDescriptorManager.getMainWikiId());
        }
        if ((events = query.execute()).isEmpty()) {
            return null;
        }
        return (LegacyEvent)events.get(0);
    }

    public Event getEvent(String eventId) throws QueryException {
        LegacyEvent legacyEvent = this.getLegacyEvent(eventId);
        if (legacyEvent != null) {
            return this.eventConverter.convertLegacyActivityToEvent(legacyEvent);
        }
        return null;
    }

    public long countEvents() throws QueryException {
        Query query = this.queryManager.createQuery("select count(*) from LegacyEvent", "hql");
        return (Long)query.execute().get(0);
    }
}

