/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.XWikiHibernateStore;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatusManager;
import org.xwiki.eventstream.store.internal.LegacyEvent;
import org.xwiki.eventstream.store.internal.LegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEventStatusManager;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={LegacyEventDeleter.class})
@Singleton
public class LegacyEventDeleter {
    @Inject
    private LegacyEventConverter eventConverter;
    @Inject
    private EventStatusManager statusManager;
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;

    public void deleteEvent(Event event) {
        LegacyEvent legacyEvent = this.eventConverter.convertEventToLegacyActivity(event);
        boolean hasBeenDeletedOnMainStore = false;
        try {
            if (this.configuration.useLocalStore() && this.wikiDescriptorManager.exists(legacyEvent.getWiki())) {
                this.deleteLegacyEvent(legacyEvent, legacyEvent.getWiki());
                hasBeenDeletedOnMainStore = this.wikiDescriptorManager.isMainWiki(legacyEvent.getWiki());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to delete the event [{}] in the local store.", (Object)event.getId(), (Object)e);
        }
        if (this.configuration.useMainStore() && !hasBeenDeletedOnMainStore) {
            try {
                this.deleteLegacyEvent(legacyEvent, this.wikiDescriptorManager.getMainWikiId());
            }
            catch (Exception e) {
                this.logger.error("Failed to delete the event [{}] in the main store.", (Object)event.getId(), (Object)e);
            }
        }
    }

    private void deleteLegacyEvent(LegacyEvent event, String wikiId) throws Exception {
        this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            hibernateStore.executeWrite(context, session -> {
                if (this.statusManager instanceof LegacyEventStatusManager) {
                    ((LegacyEventStatusManager)this.statusManager).deleteAllForEventInStore(session, event.getEventId());
                }
                session.delete((Object)event);
                return null;
            });
            return null;
        });
    }
}

