/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.store.hibernate.HibernateSessionFactory;
import com.xpn.xwiki.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="EventStreamStoreInitializer")
@Singleton
public class EventStreamStoreInitializer
implements EventListener {
    @Inject
    private HibernateSessionFactory sessionFactory;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return Collections.singletonList(new ApplicationStartedEvent());
    }

    public String getName() {
        return "Event Stream Store";
    }

    public void onEvent(Event event, Object source, Object data) {
        String driverClass = StringUtils.defaultString((String)this.sessionFactory.getConfiguration().getProperty("hibernate.connection.driver_class"), (String)this.sessionFactory.getConfiguration().getProperty("connection.driver_class"));
        if (StringUtils.containsIgnoreCase((CharSequence)driverClass, (CharSequence)"oracle")) {
            this.addResource("eventstream.oracle.hbm.xml");
        } else {
            this.addResource("eventstream.hbm.xml");
        }
    }

    private void addResource(String resource) {
        try (InputStream stream = this.getMappingFile(resource);){
            this.sessionFactory.getConfiguration().addInputStream(stream);
        }
        catch (IOException e) {
            this.logger.error("Failed to close the resource", (Throwable)e);
        }
    }

    private InputStream getMappingFile(String mappingFileName) {
        InputStream resource = Util.getResourceAsStream((String)mappingFileName);
        if (resource == null) {
            resource = this.getClass().getClassLoader().getResourceAsStream(mappingFileName);
        }
        return resource;
    }
}

