/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={EventStreamCleaner.class})
@Singleton
public class EventStreamCleaner {
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private EventStream eventStream;
    @Inject
    private EventStore eventStore;
    @Inject
    private QueryManager queryManager;
    @Inject
    private Logger logger;

    public void clean() {
        int days = this.configuration.getNumberOfDaysToKeep();
        if (days > 0) {
            try {
                Query query = this.queryManager.createQuery("where event.date < :date", "hql");
                query.bindValue("date", (Object)DateUtils.addDays((Date)new Date(), (int)(-days)));
                for (Event event : this.eventStream.searchEvents(query)) {
                    this.eventStore.deleteEvent(event);
                }
            }
            catch (QueryException e) {
                this.logger.error("Impossible to clean the old events of the event stream.", (Throwable)e);
            }
        }
    }
}

