/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal.tree.pinned;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.internal.nestedpages.pinned.PinnedChildPagesManager;
import org.xwiki.index.tree.pinned.PinnedChildPagesResource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.index.internal.tree.pinned.DefaultPinnedChildPagesResource")
public class DefaultPinnedChildPagesResource
extends XWikiResource
implements PinnedChildPagesResource {
    @Inject
    private PinnedChildPagesManager pinnedChildPagesManager;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    public List<String> parseSpaceSegments(String spaceName) throws XWikiRestException {
        return super.parseSpaceSegments(spaceName.substring("/spaces/".length()));
    }

    public List<String> getPinnedChildPages(String wikiName, String spaceName) throws XWikiRestException {
        WikiReference homeReference;
        if (!StringUtils.isEmpty((CharSequence)spaceName)) {
            List<String> spaces = this.parseSpaceSegments(spaceName);
            homeReference = new DocumentReference(wikiName, spaces, this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName());
        } else {
            homeReference = new WikiReference(wikiName);
        }
        List pinnedChildPages = this.pinnedChildPagesManager.getPinnedChildPages((EntityReference)homeReference);
        return pinnedChildPages.stream().map(x$0 -> (String)this.entityReferenceSerializer.serialize(x$0, new Object[0])).toList();
    }

    public Response setPinnedChildPages(String wikiName, String spaceName, List<String> pinnedChildPages) throws XWikiRestException {
        List<String> spaces;
        WikiReference homeReference;
        if (!StringUtils.isEmpty((CharSequence)spaceName) ? !this.authorizationManager.hasAccess(Right.EDIT, (EntityReference)(homeReference = new DocumentReference(wikiName, spaces = this.parseSpaceSegments(spaceName), this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName()))) : !this.authorizationManager.hasAccess(Right.ADMIN, (EntityReference)(homeReference = new WikiReference(wikiName)))) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<DocumentReference> pinnedChildPagesRef = pinnedChildPages.stream().map(x$0 -> this.documentReferenceResolver.resolve(x$0, new Object[0])).toList();
        this.pinnedChildPagesManager.setPinnedChildPages((EntityReference)homeReference, pinnedChildPagesRef);
        return Response.accepted().build();
    }
}

