/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.parentchild;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component(roles={DocumentQueryHelper.class})
@Singleton
public class DocumentQueryHelper {
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    @Named(value="hidden/document")
    private Provider<QueryFilter> hiddenDocumentQueryFilterProvider;
    @Inject
    private QueryManager queryManager;

    public Query getQuery(List<String> constraints, Map<String, Object> parameters, Map<String, Object> config) throws QueryException {
        String fromClause = "";
        ArrayList<String> finalConstraints = new ArrayList<String>();
        HashMap<String, Object> finalParameters = new HashMap<String, Object>();
        String xclass = (String)config.get("filterByClass");
        if (!StringUtils.isEmpty((CharSequence)xclass)) {
            fromClause = ", BaseObject as obj";
            finalConstraints.add("obj.name = doc.fullName");
            finalConstraints.add("obj.className = :class");
            finalConstraints.add("doc.fullName <> :template");
            finalParameters.put("class", xclass);
            finalParameters.put("template", StringUtils.removeEnd((String)xclass, (String)"Class") + "Template");
        }
        finalConstraints.addAll(constraints);
        finalParameters.putAll(parameters);
        String whereClause = "where " + StringUtils.join(finalConstraints, (String)" and ");
        String statement = StringUtils.join(Arrays.asList(fromClause, whereClause, "order by lower(doc.name), doc.name"), (char)' ');
        Query query = this.queryManager.createQuery(statement, "hql");
        for (Map.Entry entry : finalParameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        if (Boolean.TRUE.equals(config.get("filterHiddenDocuments"))) {
            query.addFilter((QueryFilter)this.hiddenDocumentQueryFilterProvider.get());
        }
        return query;
    }

    public List<DocumentReference> resolve(Query query, int offset, int limit, EntityReference parentReference) throws QueryException {
        query.setOffset(offset);
        query.setLimit(limit);
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
        for (Object result : query.execute()) {
            documentReferences.add(this.explicitDocumentReferenceResolver.resolve((Object)((String)result), new Object[]{parentReference}));
        }
        return documentReferences;
    }
}

