/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.parentchild;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractChildDocumentsTreeNodeGroup;
import org.xwiki.index.tree.internal.parentchild.DocumentQueryHelper;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="childDocuments/parentChild")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ChildDocumentsTreeNodeGroup
extends AbstractChildDocumentsTreeNodeGroup {
    private static final String IS_NOT_TRANSLATION = "doc.translation = 0";
    @Inject
    @Named(value="count")
    protected QueryFilter countQueryFilter;
    @Inject
    private DocumentQueryHelper documentQueryHelper;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;

    protected ChildDocumentsTreeNodeGroup(String type) {
        super("childDocuments");
    }

    @Override
    protected List<DocumentReference> getChildDocuments(EntityReference parentReference, int offset, int limit) throws QueryException {
        if (parentReference.getType() == EntityType.WIKI) {
            return this.getChildDocuments(new WikiReference(parentReference), offset, limit);
        }
        return this.getChildDocuments(new DocumentReference(parentReference), offset, limit);
    }

    private List<DocumentReference> getChildDocuments(WikiReference parentReference, int offset, int limit) throws QueryException {
        return this.documentQueryHelper.resolve(this.getChildrenQuery(parentReference), offset, limit, (EntityReference)parentReference);
    }

    private List<DocumentReference> getChildDocuments(DocumentReference parentReference, int offset, int limit) throws QueryException {
        return this.documentQueryHelper.resolve(this.getChildrenQuery(parentReference), offset, limit, (EntityReference)parentReference);
    }

    private Query getChildrenQuery(DocumentReference parentReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        constraints.add(IS_NOT_TRANSLATION);
        constraints.add("(doc.parent in (:absoluteRef, :localRef) or (doc.space = :space and doc.parent = :relativeRef))");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("space", this.localEntityReferenceSerializer.serialize(parentReference.getParent(), new Object[0]));
        parameters.put("absoluteRef", this.defaultEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[0]));
        parameters.put("localRef", this.localEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[0]));
        parameters.put("relativeRef", this.compactEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[]{parentReference.getParent()}));
        Query query = this.documentQueryHelper.getQuery(constraints, parameters, this.getProperties());
        query.setWiki(parentReference.getWikiReference().getName());
        return query;
    }

    private Query getChildrenQuery(WikiReference parentReference) throws QueryException {
        Query query = this.documentQueryHelper.getQuery(Arrays.asList("(doc.parent = '' or doc.parent is null)", IS_NOT_TRANSLATION), Collections.emptyMap(), this.getProperties());
        query.setWiki(parentReference.getName());
        return query;
    }

    @Override
    protected int getChildDocumentsCount(EntityReference parentReference) throws QueryException {
        if (parentReference.getType() == EntityType.WIKI) {
            return this.getChildDocumentsCount(new WikiReference(parentReference));
        }
        return this.getChildDocumentsCount(new DocumentReference(parentReference));
    }

    private int getChildDocumentsCount(WikiReference parentReference) throws QueryException {
        Query query = this.getChildrenQuery(parentReference);
        query.addFilter(this.countQueryFilter);
        return ((Long)query.execute().get(0)).intValue();
    }

    private int getChildDocumentsCount(DocumentReference parentReference) throws QueryException {
        Query query = this.getChildrenQuery(parentReference);
        query.addFilter(this.countQueryFilter);
        return ((Long)query.execute().get(0)).intValue();
    }

    @Override
    protected boolean canHaveChildDocuments(EntityReference parentReference) {
        return parentReference.getType() == EntityType.WIKI || parentReference.getType() == EntityType.DOCUMENT;
    }
}

