/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedspaces.parentchild;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="space/parentChildOnNestedSpaces")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class SpaceTreeNode
extends org.xwiki.index.tree.internal.nestedspaces.SpaceTreeNode {
    private static final String PARAMETER_ABSOLUTE_REFERENCE = "absoluteRef";
    private static final String PARAMETER_LOCAL_REFERENCE = "localRef";
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    @Named(value="topLevelPage/parentChildOnNestedSpaces")
    private QueryFilter topLevelPageFilter;

    @Override
    protected List<? extends EntityReference> getChildren(SpaceReference spaceReference, int offset, int limit) throws QueryException {
        Query query = this.getChildrenQuery(spaceReference, offset, limit);
        if (this.areTerminalDocumentsShown()) {
            query.addFilter(this.topLevelPageFilter);
            DocumentReference absoluteReference = this.explicitDocumentReferenceResolver.resolve((Object)String.valueOf('%'), new Object[]{spaceReference});
            query.bindValue(PARAMETER_ABSOLUTE_REFERENCE, this.defaultEntityReferenceSerializer.serialize((EntityReference)absoluteReference, new Object[0]));
            query.bindValue(PARAMETER_LOCAL_REFERENCE, this.localEntityReferenceSerializer.serialize((EntityReference)absoluteReference, new Object[0]));
        }
        return query.execute();
    }

    @Override
    protected int getChildDocumentsCount(SpaceReference spaceReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String hasNoParent = "doc.parent = '' or doc.parent is null";
        String hasParentOutsideSpace = "doc.parent like '%.%' and doc.parent not like :absoluteRef and doc.parent not like :localRef";
        constraints.add(String.format("((%s) or (%s))", hasNoParent, hasParentOutsideSpace));
        DocumentReference absoluteReference = this.explicitDocumentReferenceResolver.resolve((Object)String.valueOf('%'), new Object[]{spaceReference});
        parameters.put(PARAMETER_ABSOLUTE_REFERENCE, this.defaultEntityReferenceSerializer.serialize((EntityReference)absoluteReference, new Object[0]));
        parameters.put(PARAMETER_LOCAL_REFERENCE, this.localEntityReferenceSerializer.serialize((EntityReference)absoluteReference, new Object[0]));
        return this.getChildDocumentsCount(spaceReference, constraints, parameters);
    }
}

