/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages.pinned;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.index.tree.internal.nestedpages.pinned.PinnedChildPagesManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.tree.TreeNodeGroup;

@Component
@Named(value="pinnedChildPages")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class PinnedChildPagesTreeNodeGroup
extends AbstractEntityTreeNode
implements TreeNodeGroup {
    public static final String HINT = "pinnedChildPages";
    @Inject
    private PinnedChildPagesManager pinnedChildPagesManager;

    public PinnedChildPagesTreeNodeGroup() {
        super(HINT);
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        List<DocumentReference> pinnedChildPages = this.getPinnedChildPages(nodeId);
        return this.serialize(pinnedChildPages.subList(offset, limit < 0 ? pinnedChildPages.size() : Math.min(offset + limit, pinnedChildPages.size())));
    }

    public int getChildCount(String nodeId) {
        return this.getPinnedChildPages(nodeId).size();
    }

    private List<DocumentReference> getPinnedChildPages(String nodeId) {
        List filters = this.getProperties().getOrDefault("filters", Collections.emptyList());
        if ("reference".equals(this.getProperties().get("hierarchyMode")) && filters.contains(HINT)) {
            EntityReference parentReference = this.resolve(nodeId);
            return this.pinnedChildPagesManager.getPinnedChildPages(parentReference);
        }
        return Collections.emptyList();
    }
}

