/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages.pinned;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.internal.nestedpages.pinned.PinnedChildPagesClassInitializer;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReferenceResolver;

@Component(roles={PinnedChildPagesManager.class})
@Singleton
public class PinnedChildPagesManager {
    private static final String NESTED_PAGE_MARKER = "/";
    private static final String WIKI_PREFERENCES = "XWikiPreferences";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private ContextualLocalizationManager contextLocalization;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceResolver;

    public EntityReference getParent(DocumentReference childReference) {
        if (this.isTerminalPage(childReference)) {
            return childReference.getParent();
        }
        return childReference.getParent().getParent();
    }

    public List<DocumentReference> getPinnedChildPages(EntityReference parentReference) {
        return this.getPinnedChildPagesStorage(parentReference).map(this::getPinnedChildPages).orElse(Collections.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPinnedChildPages(EntityReference parentReference, List<DocumentReference> pagesToPin) {
        EntityReference parentEntityReference;
        if (parentReference instanceof DocumentReference) {
            if (!parentReference.getName().equals(this.getDefaultDocumentName())) throw new IllegalArgumentException(String.format("Invalid parent reference [%s], only nested document reference are allowed.", parentReference));
            parentEntityReference = parentReference.getParent();
        } else {
            parentEntityReference = parentReference;
        }
        List<DocumentReference> pinnedChildPages = pagesToPin.stream().filter(childReference -> {
            if (!Objects.equals(this.getParent((DocumentReference)childReference), parentEntityReference)) {
                this.logger.warn("Page [{}] is not a child of [{}] so it won't be pinned.", childReference, (Object)parentEntityReference);
                return false;
            }
            return true;
        }).toList();
        this.getPinnedChildPagesStorage(parentReference).ifPresent(storageReference -> this.setPinnedChildPages((DocumentReference)storageReference, pinnedChildPages));
    }

    private boolean isTerminalPage(DocumentReference documentReference) {
        return !this.getDefaultDocumentName().equals(documentReference.getName());
    }

    private String getDefaultDocumentName() {
        return this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
    }

    private List<DocumentReference> getPinnedChildPages(DocumentReference storageReference) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument storageDocument = xcontext.getWiki().getDocument(storageReference, xcontext);
            DocumentReference classReference = new DocumentReference(PinnedChildPagesClassInitializer.CLASS_REFERENCE, storageReference.getWikiReference());
            List value = storageDocument.getListValue(classReference, "pinnedChildPages");
            return this.resolvePinnedChildPages(storageReference, value);
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the list of pinned child pages from [{}]. Root cause is [{}].", (Object)storageReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }

    private void setPinnedChildPages(DocumentReference storageReference, List<DocumentReference> pinnedChildPages) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument storageDocument = xcontext.getWiki().getDocument(storageReference, xcontext).clone();
            if (storageDocument.isNew()) {
                storageDocument.setHidden(Boolean.valueOf(true));
            }
            storageDocument.getAuthors().setOriginalMetadataAuthor(this.currentUserReferenceResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]));
            List<String> value = this.serializePinnedChildPages(pinnedChildPages);
            storageDocument.setStringListValue((EntityReference)PinnedChildPagesClassInitializer.CLASS_REFERENCE, "pinnedChildPages", value);
            String saveComment = this.contextLocalization.getTranslationPlain("index.tree.pinnedChildPages.saveComment", new Object[0]);
            xcontext.getWiki().saveDocument(storageDocument, saveComment, true, xcontext);
        }
        catch (Exception e) {
            this.logger.warn("Failed to update the list of pinned child pages to [{}]. Root cause is [{}].", (Object)storageReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private Optional<DocumentReference> getPinnedChildPagesStorage(EntityReference parentReference) {
        if (parentReference == null) {
            return Optional.empty();
        }
        if (parentReference.getType() == EntityType.WIKI) {
            return Optional.of(new DocumentReference(parentReference.getName(), "XWiki", WIKI_PREFERENCES));
        }
        if (parentReference.getType() == EntityType.SPACE) {
            return Optional.of(new DocumentReference("WebPreferences", new SpaceReference(parentReference)));
        }
        if (parentReference.getType() == EntityType.DOCUMENT && this.getDefaultDocumentName().equals(parentReference.getName())) {
            return this.getPinnedChildPagesStorage((EntityReference)new DocumentReference(parentReference).getLastSpaceReference());
        }
        return Optional.empty();
    }

    private List<String> serializePinnedChildPages(List<DocumentReference> pinnedChildPages) {
        return pinnedChildPages.stream().map(this::serializePinnedChildPage).toList();
    }

    private String serializePinnedChildPage(DocumentReference pinnedChildPage) {
        boolean isTerminalPage = this.isTerminalPage(pinnedChildPage);
        Object name = isTerminalPage ? pinnedChildPage.getName() : pinnedChildPage.getLastSpaceReference().getName();
        name = ((String)name).replace("%", "%25").replace(NESTED_PAGE_MARKER, "%2F").replace("+", "%2B");
        if (!isTerminalPage) {
            name = (String)name + NESTED_PAGE_MARKER;
        }
        return name;
    }

    private List<DocumentReference> resolvePinnedChildPages(DocumentReference storageReference, List<String> pinnedChildPages) {
        return pinnedChildPages.stream().map(pinnedChildPage -> this.resolvePinnedChildPage(storageReference, (String)pinnedChildPage)).toList();
    }

    private DocumentReference resolvePinnedChildPage(DocumentReference storageReference, String pinnedChildPage) {
        SpaceReference parentReference = storageReference.getLastSpaceReference();
        DocumentReference wikiPreferencesReference = new DocumentReference(storageReference.getWikiReference().getName(), "XWiki", WIKI_PREFERENCES);
        if (wikiPreferencesReference.equals((Object)storageReference)) {
            parentReference = storageReference.getWikiReference();
        }
        boolean isTerminal = parentReference instanceof SpaceReference && !pinnedChildPage.endsWith(NESTED_PAGE_MARKER);
        String childPageName = URLDecoder.decode(StringUtils.removeEnd((String)pinnedChildPage, (String)NESTED_PAGE_MARKER), StandardCharsets.UTF_8);
        if (isTerminal) {
            return new DocumentReference(childPageName, parentReference);
        }
        return new DocumentReference(this.getDefaultDocumentName(), new SpaceReference(childPageName, (EntityReference)parentReference));
    }
}

