/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractDocumentRelatedTreeNode;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="translations")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class TranslationsTreeNode
extends AbstractDocumentRelatedTreeNode {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public TranslationsTreeNode() {
        super("translations");
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        String serializedDocRef = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
        List locales = document.getTranslationLocales(xcontext);
        ArrayList<String> children = new ArrayList<String>();
        for (Locale locale : this.subList(locales, offset, limit)) {
            children.add("translation:" + serializedDocRef + "/" + String.valueOf(locale));
        }
        return children;
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return document.getTranslationLocales(xcontext).size();
    }
}

