/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractDocumentRelatedTreeNode;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="classProperties")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ClassPropertiesTreeNode
extends AbstractDocumentRelatedTreeNode {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public ClassPropertiesTreeNode() {
        super("classProperties");
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        ArrayList properties = new ArrayList(document.getXClass().getPropertyList());
        Collections.sort(properties);
        ArrayList<String> children = new ArrayList<String>();
        for (String property : this.subList(properties, offset, limit)) {
            children.add(this.serialize((EntityReference)new ClassPropertyReference(property, documentReference)));
        }
        return children;
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return document.getXClass().getPropertyList().size();
    }
}

