/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.Converter;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.tree.AbstractTreeNode;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;

public abstract class AbstractEntityTreeNode
extends AbstractTreeNode {
    protected static final String FARM_NODE_ID = "farm:*";
    @Inject
    protected EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="local")
    protected EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    protected QueryManager queryManager;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    @Named(value="entityTreeNodeId")
    private Converter<EntityReference> entityTreeNodeIdConverter;

    protected AbstractEntityTreeNode(String type) {
        super(type);
    }

    protected EntityReference resolve(String nodeId) {
        return (EntityReference)this.entityTreeNodeIdConverter.convert(EntityReference.class, (Object)nodeId);
    }

    protected String serialize(EntityReference entityReference) {
        return (String)this.entityTreeNodeIdConverter.convert(String.class, (Object)entityReference);
    }

    protected <E extends EntityReference> List<String> serialize(List<E> entityReferences) {
        return entityReferences.stream().map(this::serialize).collect(Collectors.toList());
    }

    protected boolean areHiddenEntitiesShown() {
        boolean shown;
        boolean bl = shown = !Boolean.TRUE.equals(this.getProperties().get("filterHiddenDocuments"));
        if (!shown) {
            shown = this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]).displayHiddenDocuments();
        }
        return shown;
    }

    protected String whereClause(List<String> constraints) {
        return "where " + StringUtils.join(constraints, (String)" and ");
    }

    protected int getChildSpacesCount(EntityReference parentReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        EntityReference parentSpaceReference = parentReference.extractReference(EntityType.SPACE);
        if (parentSpaceReference != null) {
            constraints.add("parent = :parent");
            parameters.put("parent", this.localEntityReferenceSerializer.serialize(parentSpaceReference, new Object[0]));
        } else {
            constraints.add("parent is null");
        }
        if (!this.areHiddenEntitiesShown()) {
            constraints.add("hidden <> true");
        }
        EntityReference wikiReference = parentReference.extractReference(EntityType.WIKI);
        Set<String> excludedSpaces = this.getExcludedSpaces(parentSpaceReference != null ? parentSpaceReference : wikiReference);
        if (!excludedSpaces.isEmpty()) {
            constraints.add("reference not in (:excludedSpaces)");
            parameters.put("excludedSpaces", excludedSpaces);
        }
        String statement = "select count(*) from XWikiSpace " + this.whereClause(constraints);
        Query query = this.queryManager.createQuery(statement, "hql");
        query.setWiki(wikiReference.getName());
        for (Map.Entry entry : parameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        return ((Long)query.execute().get(0)).intValue();
    }

    protected String getDefaultDocumentName() {
        return this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
    }

    protected boolean areTerminalDocumentsShown() {
        return !Boolean.FALSE.equals(this.getProperties().get("showTerminalDocuments"));
    }

    protected Set<EntityReference> getExcludedEntities(String parentNodeId) {
        return this.getExclusions(parentNodeId).stream().map(this::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected Set<String> getExcludedWikis() {
        return this.getExcludedEntities(FARM_NODE_ID).stream().filter(AbstractEntityTreeNode::isWiki).map(EntityReference::getName).collect(Collectors.toSet());
    }

    protected Set<String> getExcludedSpaces(EntityReference parentReference) {
        return this.getExcludedEntities(this.serialize(parentReference)).stream().filter(entityReference -> this.isSpace((EntityReference)entityReference) || this.isNestedDocument((EntityReference)entityReference)).filter(entityReference -> entityReference.hasParent(parentReference)).map(entityReference -> (String)this.localEntityReferenceSerializer.serialize(entityReference.extractReference(EntityType.SPACE), new Object[0])).collect(Collectors.toSet());
    }

    protected Set<String> getExcludedDocuments(EntityReference parentReference) {
        return this.getExcludedEntities(this.serialize(parentReference)).stream().filter(this::isTerminalDocument).filter(entityReference -> entityReference.hasParent(parentReference)).map(entityReference -> (String)this.localEntityReferenceSerializer.serialize(entityReference, new Object[0])).collect(Collectors.toSet());
    }

    private static boolean isWiki(EntityReference entityReference) {
        return entityReference.getType() == EntityType.WIKI;
    }

    private boolean isSpace(EntityReference entityReference) {
        return entityReference.getType() == EntityType.SPACE;
    }

    private boolean isNestedDocument(EntityReference entityReference) {
        return entityReference.getType() == EntityType.DOCUMENT && Objects.equals(entityReference.getName(), this.getDefaultDocumentName());
    }

    private boolean isTerminalDocument(EntityReference entityReference) {
        return entityReference.getType() == EntityType.DOCUMENT && !Objects.equals(entityReference.getName(), this.getDefaultDocumentName());
    }
}

