/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.doc.tasks.XWikiDocumentIndexingTask;

@Component(roles={TasksStore.class})
@Singleton
public class TasksStore
extends XWikiHibernateBaseStore {
    private static final String QUERY_TASK_DELETION = "delete from XWikiDocumentIndexingTask t where t.docId = :docId and t.type = :type ";
    private static final String DOC_ID = "docId";
    private static final String TYPE = "type";
    @Inject
    private ExecutionContextManager contextManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public List<XWikiDocumentIndexingTask> getAllTasks(String wikiId, String instanceId) throws XWikiException {
        return this.initWikiContext(xWikiContext -> (List)this.executeRead(xWikiContext, session -> session.createQuery("SELECT t FROM XWikiDocumentIndexingTask t WHERE t.instanceId = :instanceId").setParameter("instanceId", (Object)instanceId).getResultList()), wikiId);
    }

    public void addTask(String wikiId, XWikiDocumentIndexingTask task) throws XWikiException {
        this.initWikiContext(xWikiContext -> {
            this.executeWrite(xWikiContext, session -> {
                this.innerAddTask(task, session);
                return null;
            });
            return null;
        }, wikiId);
    }

    public void deleteTask(String wikiId, long docId, String version, String type) throws XWikiException {
        this.initWikiContext(xWikiContext -> {
            this.executeWrite(xWikiContext, session -> {
                Object query = QUERY_TASK_DELETION;
                query = StringUtils.isEmpty((CharSequence)version) ? (String)query + "and (t.version = :version or t.version is null)" : (String)query + "and t.version = :version";
                session.createQuery((String)query).setParameter(DOC_ID, (Object)docId).setParameter("version", (Object)version).setParameter(TYPE, (Object)type).executeUpdate();
                return null;
            });
            return null;
        }, wikiId);
    }

    public void replaceTask(String wikiId, XWikiDocumentIndexingTask task) throws XWikiException {
        this.initWikiContext(xWikiContext -> {
            this.executeWrite(xWikiContext, session -> {
                session.createQuery(QUERY_TASK_DELETION).setParameter(DOC_ID, (Object)task.getDocId()).setParameter(TYPE, (Object)task.getType()).executeUpdate();
                this.innerAddTask(task, session);
                return null;
            });
            return null;
        }, wikiId);
    }

    public XWikiDocument getDocument(String wikiId, long docId) throws XWikiException {
        return this.initWikiContext(context -> (XWikiDocument)this.executeRead(context, session -> (XWikiDocument)session.createQuery("select doc from XWikiDocument doc where doc.id = :docId").setParameter(DOC_ID, (Object)docId).getSingleResult()), wikiId);
    }

    private <T> T initWikiContext(Lambda<T> r, String wikiId) throws XWikiException {
        ExecutionContext executionContext = new ExecutionContext();
        try {
            this.contextManager.pushContext(executionContext, false);
            this.contextManager.initialize(executionContext);
            XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
            xWikiContext.setWikiId(wikiId);
            T t = r.call(xWikiContext);
            return t;
        }
        catch (Exception e) {
            throw new XWikiException("Failed to executed the task in the context", (Throwable)e);
        }
        finally {
            this.contextManager.popContext();
        }
    }

    private void innerAddTask(XWikiDocumentIndexingTask task, Session session) {
        if (task.getTimestamp() == null) {
            task.setTimestamp(new Date());
        }
        session.saveOrUpdate((Object)task);
    }

    @FunctionalInterface
    private static interface Lambda<T> {
        public T call(XWikiContext var1) throws Exception;
    }
}

