/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.index.internal.TaskData;
import org.xwiki.index.internal.TasksStore;

@Component(roles={TaskExecutor.class})
@Singleton
public class TaskExecutor {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Provider<TasksStore> tasksStore;
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private ExecutionContextManager contextManager;

    public void execute(TaskData task) throws IndexException {
        ExecutionContext executionContext = new ExecutionContext();
        try {
            this.contextManager.pushContext(executionContext, false);
            this.contextManager.initialize(executionContext);
            XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
            xWikiContext.setWikiId(task.getWikiId());
            this.internalExecute(task);
        }
        catch (ComponentLookupException e) {
            throw new IndexException(String.format("Failed to find a task consumer for task [%s]", task), (Throwable)e);
        }
        catch (XWikiException | ExecutionContextException e) {
            throw new IndexException(String.format("Error during the execution of task [%s]", task), e);
        }
        finally {
            this.contextManager.popContext();
        }
    }

    private void internalExecute(TaskData task) throws XWikiException, IndexException, ComponentLookupException {
        XWikiDocument document = ((TasksStore)((Object)this.tasksStore.get())).getDocument(task.getWikiId(), task.getDocId());
        XWikiDocument doc = StringUtils.isBlank((CharSequence)task.getVersion()) ? document : this.documentRevisionProvider.getRevision(document, task.getVersion());
        ((TaskConsumer)((ComponentManager)this.componentManager.get()).getInstance(TaskConsumer.class, task.getType())).consume(doc.getDocumentReferenceWithLocale(), doc.getVersion());
    }
}

