/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal;

import com.xpn.xwiki.XWikiException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.doc.tasks.XWikiDocumentIndexingTask;
import org.xwiki.index.TaskManager;
import org.xwiki.index.internal.TaskData;
import org.xwiki.index.internal.TaskExecutor;
import org.xwiki.index.internal.TasksStore;
import org.xwiki.index.internal.jmx.JMXTasks;
import org.xwiki.management.JMXBeanRegistration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultTasksManager
implements TaskManager,
Initializable,
Disposable,
Runnable {
    private static final String MBEAN_NAME = "name=index";
    private PriorityBlockingQueue<TaskData> queue;
    private ConcurrentHashMap<TaskData, Long> latestTimestampTasksMap;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<TasksStore> tasksStore;
    @Inject
    private RemoteObservationManagerConfiguration remoteObservationManagerConfiguration;
    @Inject
    private JMXBeanRegistration jmxRegistration;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    private Logger logger;
    private boolean halt;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public CompletableFuture<TaskData> addTask(String wikiId, long docId, String type) {
        return this.addTask(wikiId, docId, "", type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<TaskData> addTask(String wikiId, long docId, String version, String type) {
        XWikiDocumentIndexingTask xWikiTask = this.initTask(docId, type, version);
        this.readLock.lock();
        try {
            try {
                ((TasksStore)((Object)this.tasksStore.get())).addTask(wikiId, xWikiTask);
            }
            catch (Exception e) {
                this.logger.warn("Failed to add a task for docId [{}], type [{}] and version [{}] in wiki [{}]. This task is queued but will not be will not be restarted if not completed before the server stops. Cause: [{}].", new Object[]{docId, type, version, wikiId, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            TaskData taskData = this.convert(wikiId, xWikiTask);
            this.latestTimestampTasksMap.put(taskData, taskData.getTimestamp());
            this.queue.add(taskData);
            CompletableFuture completableFuture = taskData.getFuture();
            return completableFuture;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void initialize() {
        this.jmxRegistration.registerMBean((Object)new JMXTasks(this::getQueueSize, () -> this.queue.stream().collect(Collectors.groupingBy(TaskData::getType, Collectors.counting()))), MBEAN_NAME);
        this.queue = new PriorityBlockingQueue<TaskData>(11, Comparator.comparingLong(TaskData::getTimestamp));
        this.latestTimestampTasksMap = new ConcurrentHashMap();
    }

    public void dispose() {
        this.jmxRegistration.unregisterMBean(MBEAN_NAME);
        this.queue.add(TaskData.STOP);
    }

    public void startThread() {
        Thread thread = new Thread(this);
        thread.setName("task-manager-consumer");
        thread.setPriority(4);
        thread.start();
    }

    public long getQueueSize() {
        return this.queue.size();
    }

    public long getQueueSize(String type) {
        return this.queue.stream().filter(taskData -> Objects.equals(taskData.getType(), type)).count();
    }

    public Map<String, Long> getQueueSizePerType(String wikiId) {
        return this.queue.stream().filter(taskData -> Objects.equals(taskData.getWikiId(), wikiId)).collect(Collectors.groupingBy(TaskData::getType, Collectors.counting()));
    }

    @Override
    public void run() {
        try {
            this.initQueue();
            while (!this.halt) {
                this.consume();
            }
        }
        catch (InitializationException e) {
            this.logger.error("Failed to initialize the tasks consumer thread.", (Throwable)e);
        }
    }

    private void consume() {
        block10: {
            TaskData task = null;
            try {
                task = this.queue.take();
                task.increaseAttempts();
                if (task.isStop()) {
                    this.halt = true;
                } else {
                    if (this.isTimestampValid(task)) {
                        this.taskExecutor.execute(task);
                        task.getFuture().complete(task);
                    } else {
                        task.getFuture().cancel(false);
                    }
                    this.deleteTask(task);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("The task manager consumer thread was interrupted while processing task [{}] for document [{}]. Cause: [{}].", new Object[]{task, this.getTaskDocumentReferenceForLogging(task), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.logger.warn("Error during the execution of task [{}] for document [{}]. Cause: [{}].", new Object[]{task, this.getTaskDocumentReferenceForLogging(task), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                this.logger.debug("Stack trace for previous error: ", (Throwable)e);
                if (task != null && this.isTimestampValid(task)) {
                    if (!task.tooManyAttempts()) {
                        long newTimestamp = System.currentTimeMillis();
                        this.latestTimestampTasksMap.put(task, newTimestamp);
                        task.setTimestamp(newTimestamp);
                        this.queue.put(task);
                    } else {
                        this.logger.error("[{}] abandoned because it has failed too many times.", (Object)task, (Object)e);
                        this.deleteTask(task);
                        task.getFuture().cancel(false);
                    }
                }
                if (task == null) break block10;
                task.getFuture().cancel(false);
            }
        }
    }

    private void initQueue() throws InitializationException {
        try {
            this.executionContextManager.initialize(new ExecutionContext());
            for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                this.loadWiki(wikiId);
            }
        }
        catch (WikiManagerException e) {
            throw new InitializationException("Failed to list the wiki IDs.", (Throwable)e);
        }
        catch (ExecutionContextException e) {
            throw new InitializationException("Error when initializing the execution context.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWiki(String wikiId) throws InitializationException {
        try {
            HashSet<TaskData> existingTasks;
            List<XWikiDocumentIndexingTask> tasksInDB = ((TasksStore)((Object)this.tasksStore.get())).getAllTasks(wikiId, this.remoteObservationManagerConfiguration.getId());
            this.writeLock.lock();
            try {
                existingTasks = new HashSet<TaskData>(this.queue);
            }
            finally {
                this.writeLock.unlock();
            }
            for (XWikiDocumentIndexingTask task : tasksInDB) {
                TaskData taskData = this.convert(wikiId, task);
                if (existingTasks.contains(taskData)) continue;
                this.latestTimestampTasksMap.computeIfAbsent(taskData, TaskData::getTimestamp);
                this.queue.put(taskData);
            }
        }
        catch (XWikiException e) {
            throw new InitializationException(String.format("Failed to get tasks for wiki [%s]", wikiId), (Throwable)e);
        }
    }

    private TaskData convert(String wikiId, XWikiDocumentIndexingTask task) {
        TaskData taskData = new TaskData();
        taskData.setTimestamp(task.getTimestamp().getTime());
        taskData.setVersion(task.getVersion());
        taskData.setDocId(task.getDocId());
        taskData.setType(task.getType());
        taskData.setWikiId(wikiId);
        return taskData;
    }

    private XWikiDocumentIndexingTask initTask(long docId, String type, String version) {
        XWikiDocumentIndexingTask xWikiTask = new XWikiDocumentIndexingTask();
        xWikiTask.setDocId(docId);
        xWikiTask.setType(type);
        xWikiTask.setVersion(version);
        xWikiTask.setInstanceId(this.remoteObservationManagerConfiguration.getId());
        xWikiTask.setTimestamp(new Date());
        return xWikiTask;
    }

    private boolean isTimestampValid(TaskData task) {
        return task.getTimestamp() == this.latestTimestampTasksMap.getOrDefault(task, 0L).longValue();
    }

    private void deleteTask(TaskData task) {
        block5: {
            this.writeLock.lock();
            try {
                if (!this.isTimestampValid(task)) break block5;
                try {
                    ((TasksStore)((Object)this.tasksStore.get())).deleteTask(task.getWikiId(), task.getDocId(), task.getVersion(), task.getType());
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to delete task [{}] from the queue. It will be reloaded on restart.", (Object)task, (Object)e);
                }
                this.latestTimestampTasksMap.remove(task);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private DocumentReference getTaskDocumentReferenceForLogging(TaskData taskData) {
        DocumentReference result;
        try {
            result = ((TasksStore)((Object)this.tasksStore.get())).getDocument(taskData.getWikiId(), taskData.getDocId()).getDocumentReference();
        }
        catch (XWikiException e) {
            result = null;
        }
        return result;
    }
}

