/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
@Named(value="links")
@Deprecated(since="14.8RC1")
public class DefaultLinksTaskConsumer
implements TaskConsumer {
    public static final String LINKS_TASK_TYPE = "links";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private Logger logger;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void consume(DocumentReference documentReference, String version) throws IndexException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        if (context.getWiki().hasBacklinks(context)) {
            try {
                XWikiDocument doc = this.documentRevisionProvider.getRevision(documentReference, version);
                if (doc == null) return;
                context.getWiki().getHibernateStore().saveLinks(doc, context, true);
                return;
            }
            catch (XWikiException e) {
                throw new IndexException(String.format("Failed to updated links for document [%s] version [%s].", documentReference, version), (Throwable)e);
            }
        } else {
            this.logger.warn("Skipping for document [{}] version [{}] because backlinks are not supported in this wiki.", (Object)documentReference, (Object)version);
        }
    }
}

