/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TaskData
implements Serializable {
    public static final TaskData STOP = new TaskData(true);
    private static final long serialVersionUID = -1288732853577861921L;
    private long timestamp;
    private String version;
    private long docId;
    private String type;
    private int attempts;
    private boolean stopFlag;
    private String wikiId;
    private final transient CompletableFuture<TaskData> future = new CompletableFuture();

    public TaskData() {
    }

    private TaskData(boolean stop) {
        this.stopFlag = stop;
        this.timestamp = 0L;
    }

    public TaskData(long docId, String version, String type, String wikiId) {
        this.docId = docId;
        this.version = version;
        this.type = type;
        this.wikiId = wikiId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TaskData setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public TaskData setVersion(String version) {
        this.version = version;
        return this;
    }

    public long getDocId() {
        return this.docId;
    }

    public TaskData setDocId(long docId) {
        this.docId = docId;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public TaskData setType(String type) {
        this.type = type;
        return this;
    }

    public void increaseAttempts() {
        ++this.attempts;
    }

    public boolean isStop() {
        return this.stopFlag;
    }

    public boolean isDeprecated() {
        return this.stopFlag && this != STOP;
    }

    public String getWikiId() {
        return this.wikiId;
    }

    public TaskData setWikiId(String wikiId) {
        this.wikiId = wikiId;
        return this;
    }

    public boolean tooManyAttempts() {
        return this.attempts > 9;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskData taskData = (TaskData)o;
        return new EqualsBuilder().append((Object)this.version, (Object)taskData.version).append(this.stopFlag, taskData.stopFlag).append(this.docId, taskData.docId).append((Object)this.type, (Object)taskData.type).append((Object)this.wikiId, (Object)taskData.wikiId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.version).append(this.docId).append((Object)this.type).append(this.stopFlag).append((Object)this.wikiId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("timestamp", this.timestamp).append("docId", this.docId).append("type", (Object)this.type).append("attempts", this.attempts).append("stop", this.stopFlag).append("wikiId", (Object)this.wikiId).append("version", (Object)this.getVersion()).toString();
    }

    public CompletableFuture<TaskData> getFuture() {
        return this.future;
    }
}

