/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.icon.rest.IconThemesResource;
import org.xwiki.icon.rest.model.jaxb.Icon;
import org.xwiki.icon.rest.model.jaxb.Icons;
import org.xwiki.icon.rest.model.jaxb.ObjectFactory;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="org.xwiki.icon.internal.DefaultIconThemesResource")
@Singleton
public class DefaultIconThemesResource
implements IconThemesResource,
XWikiRestComponent {
    @Inject
    private ModelContext modelContext;
    @Inject
    private IconManager iconManager;
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public Icons getIconsByTheme(String wikiId, String iconTheme, List<String> names) {
        return this.iconsByTheme(wikiId, iconTheme, names);
    }

    public Icons getIcons(String wikiName, List<String> names) {
        return this.iconsByTheme(wikiName, null, names);
    }

    private Icons iconsByTheme(String wikiId, String iconTheme, List<String> iconNames) {
        this.wikiExists(wikiId);
        EntityReference oldEntityReference = this.modelContext.getCurrentEntityReference();
        try {
            this.modelContext.setCurrentEntityReference((EntityReference)new WikiReference(wikiId));
            IconSet iconSet = this.getIconSet(iconTheme);
            if (iconSet == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            String iconSetName = iconSet.getName();
            ObjectFactory objectFactory = new ObjectFactory();
            Icons icons = objectFactory.createIcons();
            for (String iconName : iconNames) {
                if (this.iconManager.hasIcon(iconSetName, iconName)) {
                    Map metaData = this.iconManager.getMetaData(iconName, iconSetName);
                    icons.getIcons().add(this.convertMapToIcon(objectFactory, metaData, iconName, iconSetName));
                    continue;
                }
                if (iconName == null) continue;
                icons.getMissingIcons().add(iconName);
            }
            Icons icons2 = icons;
            return icons2;
        }
        catch (IconException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            this.modelContext.setCurrentEntityReference(oldEntityReference);
        }
    }

    private IconSet getIconSet(String iconSetName) throws IconException {
        IconSet iconSet;
        if (iconSetName == null) {
            iconSet = this.iconSetManager.getCurrentIconSet();
            if (iconSet == null) {
                iconSet = this.iconSetManager.getDefaultIconSet();
            }
        } else {
            iconSet = this.iconSetManager.getIconSet(iconSetName);
        }
        return iconSet;
    }

    private Icon convertMapToIcon(ObjectFactory objectFactory, Map<String, Object> metaData, String iconName, String setName) {
        String url;
        Icon icon = objectFactory.createIcon();
        icon.setName(iconName);
        icon.setIconSetName(setName);
        icon.setIconSetType((String)metaData.get("iconSetType"));
        String cssClass = (String)metaData.get("cssClass");
        if (StringUtils.isNotEmpty((CharSequence)cssClass)) {
            icon.setCssClass(cssClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(url = (String)metaData.get("url")))) {
            icon.setUrl(url);
        }
        return icon;
    }

    private void wikiExists(String wikiId) {
        try {
            if (!this.wikiDescriptorManager.exists(wikiId)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        catch (WikiManagerException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

