/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetCache;
import org.xwiki.icon.IconSetLoader;
import org.xwiki.icon.IconSetManager;
import org.xwiki.icon.internal.context.IconSetContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultIconSetManager
implements IconSetManager {
    private static final String DEFAULT_ICONSET_NAME = "default";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private IconSetCache iconSetCache;
    @Inject
    private IconSetLoader iconSetLoader;
    @Inject
    private IconSetContext iconSetContext;
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    @Named(value="all")
    private ConfigurationSource configurationSource;
    @Inject
    private Logger logger;

    public IconSet getCurrentIconSet() throws IconException {
        IconSet iconSet = this.iconSetContext.getIconSet();
        if (iconSet != null) {
            return iconSet;
        }
        String iconTheme = (String)this.configurationSource.getProperty("iconTheme");
        DocumentReference iconThemeDocRef = this.documentReferenceResolver.resolve((Object)iconTheme, new Object[0]);
        if (!StringUtils.isBlank((CharSequence)iconTheme) && this.exists(iconThemeDocRef) && (iconSet = this.iconSetCache.get(iconThemeDocRef)) == null) {
            iconSet = this.iconSetLoader.loadIconSet(iconThemeDocRef);
            this.iconSetCache.put(iconThemeDocRef, iconSet);
            this.iconSetCache.put(iconSet.getName(), this.wikiDescriptorManager.getCurrentWikiId(), iconSet);
        }
        return iconSet;
    }

    private boolean exists(DocumentReference iconThemeDocRef) throws IconException {
        try {
            return this.documentAccessBridge.exists(iconThemeDocRef);
        }
        catch (Exception e) {
            throw new IconException("Failed to check if the icon theme age exist", (Throwable)e);
        }
    }

    public IconSet getDefaultIconSet() throws IconException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        IconSet iconSet = this.iconSetCache.get(DEFAULT_ICONSET_NAME);
        if (iconSet == null) {
            try (InputStreamReader reader = new InputStreamReader(xwiki.getResourceAsStream("/resources/icons/default.iconset"));){
                iconSet = this.iconSetLoader.loadIconSet((Reader)reader, DEFAULT_ICONSET_NAME);
                this.iconSetCache.put(DEFAULT_ICONSET_NAME, iconSet);
            }
            catch (IOException e) {
                throw new IconException("Failed to load the current default icon set resource.", (Throwable)e);
            }
            catch (IconException e) {
                throw new IconException("Failed to get the current default icon set.", (Throwable)e);
            }
        }
        return iconSet;
    }

    public IconSet getIconSet(String name) throws IconException {
        if (DEFAULT_ICONSET_NAME.equals(name)) {
            return this.getDefaultIconSet();
        }
        IconSet iconSet = this.iconSetCache.get(name, this.wikiDescriptorManager.getCurrentWikiId());
        if (iconSet == null) {
            List results;
            try {
                String xwql = "FROM doc.object(IconThemesCode.IconThemeClass) obj WHERE obj.name = :name";
                Query query = this.queryManager.createQuery(xwql, "xwql");
                query.bindValue("name", (Object)name);
                results = query.execute();
            }
            catch (QueryException e) {
                throw new IconException(String.format("Failed to load the icon set [%s].", name), (Throwable)e);
            }
            iconSet = this.loadIconSetFromCandidateDocuments(name, results);
        }
        return iconSet;
    }

    private IconSet loadIconSetFromCandidateDocuments(String name, List<String> candidateDocuments) throws IconException {
        ArrayList<IconException> iconExceptions = new ArrayList<IconException>();
        IconSet iconSet = null;
        for (String docName : candidateDocuments) {
            DocumentReference docRef = this.documentReferenceResolver.resolve((Object)docName, new Object[0]);
            try {
                iconSet = this.iconSetLoader.loadIconSet(docRef);
                this.iconSetCache.put(docRef, iconSet);
                this.iconSetCache.put(name, this.wikiDescriptorManager.getCurrentWikiId(), iconSet);
                break;
            }
            catch (IconException e2) {
                iconExceptions.add(e2);
            }
        }
        if (iconSet == null && !iconExceptions.isEmpty()) {
            if (iconExceptions.size() > 1) {
                iconExceptions.stream().skip(1L).forEach(e -> this.logger.warn("Failed loading icon set [{}] from multiple matching documents, ignored this additional exception, reason: [{}].", (Object)name, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e)));
                throw new IconException(String.format("Failed to load the icon set [%s] from %d documents, reporting the first exception, see the log for additional errors.", name, candidateDocuments.size()), (Throwable)iconExceptions.get(0));
            }
            throw (IconException)((Object)iconExceptions.get(0));
        }
        return iconSet;
    }

    public List<String> getIconSetNames() throws IconException {
        try {
            String xwql = "SELECT obj.name FROM Document doc, doc.object(IconThemesCode.IconThemeClass) obj ORDER BY obj.name";
            Query query = this.queryManager.createQuery(xwql, "xwql");
            return query.execute();
        }
        catch (QueryException e) {
            throw new IconException("Failed to get the name of all icon sets.", (Throwable)e);
        }
    }
}

