/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.flavor.script;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.Request;
import org.xwiki.platform.flavor.FlavorManager;
import org.xwiki.platform.flavor.FlavorQuery;
import org.xwiki.platform.flavor.internal.job.FlavorSearchStatus;
import org.xwiki.platform.flavor.job.FlavorSearchRequest;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.url.ParametrizedRestURLGenerator;

@Component
@Named(value="flavor")
@Singleton
public class FlavorManagerScriptService
extends AbstractExtensionScriptService {
    public static final String ROLEHINT = "flavor";
    public static final String SEARCH_ID = "search";
    @Inject
    private FlavorManager flavorManager;
    @Inject
    @Named(value="jobstatus")
    private ParametrizedRestURLGenerator<List<String>> jobstatusURLGenerator;

    private List<String> getSearchJobId(String namespace) {
        return Arrays.asList(ROLEHINT, SEARCH_ID, namespace);
    }

    public FlavorQuery createFlavorQuery() {
        return new FlavorQuery();
    }

    public FlavorQuery createFlavorQuery(String query) {
        return new FlavorQuery(query);
    }

    @Deprecated
    public IterableResult<Extension> getFlavors(FlavorQuery query) {
        this.setError(null);
        try {
            return this.flavorManager.getFlavors(query);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public IterableResult<Extension> searchFlavors(FlavorQuery query) {
        this.setError(null);
        try {
            return this.flavorManager.searchFlavors(query);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public FlavorSearchStatus getSearchValidFlavorsStatus(String namespace) {
        return (FlavorSearchStatus)this.getJobStatus(this.getSearchJobId(namespace));
    }

    public FlavorSearchStatus getSearchValidFlavorsStatus() {
        return this.getSearchValidFlavorsStatus(this.currentNamespace());
    }

    public String getSearchValidFlavorsStatusURL(String namespace) {
        this.setError(null);
        try {
            return this.jobstatusURLGenerator.getURL(this.getSearchJobId(namespace)).getPath();
        }
        catch (XWikiRestException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<Extension> getValidExtensions() {
        return this.getValidExtensions(this.currentNamespace());
    }

    public List<Extension> getValidExtensions(String namespace) {
        FlavorSearchStatus status = this.getSearchValidFlavorsStatus(namespace);
        return status != null ? status.getFlavors() : null;
    }

    private String currentNamespace() {
        return "wiki:" + ((XWikiContext)this.xcontextProvider.get()).getWikiId();
    }

    public String getSearchValidFlavorsStatusURL() {
        return this.getSearchValidFlavorsStatusURL(this.currentNamespace());
    }

    public Job searchValidFlavors(String namespace) {
        this.setError(null);
        Job job = null;
        try {
            FlavorSearchRequest flavorRequest = new FlavorSearchRequest();
            flavorRequest.setId(this.getSearchJobId(namespace));
            flavorRequest.addNamespace(namespace);
            this.setRightsProperties((AbstractRequest)flavorRequest);
            job = this.jobExecutor.execute("searchflavors", (Request)flavorRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job searchValidFlavors() {
        return this.searchValidFlavors(this.currentNamespace());
    }

    public ExtensionId getFlavorOfWiki(String wikiId) {
        return this.flavorManager.getFlavorOfWiki(wikiId);
    }

    public InstalledExtension getFlavorExtension(Namespace namespace) {
        return (InstalledExtension)this.safe(this.flavorManager.getFlavorExtension(namespace));
    }

    public Collection<ExtensionId> getKnownFlavors() {
        return this.flavorManager.getKnownFlavors();
    }

    public Collection<String> getKnownInvalidFlavors() {
        return this.flavorManager.getKnownInvalidFlavors();
    }
}

