/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.AbstractBeanInputFilterStream;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.input.ReaderInputSource;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.input.DocumentLocaleReader;
import org.xwiki.filter.xar.internal.input.WikiReader;
import org.xwiki.filter.xar.internal.input.XARInputFilter;
import org.xwiki.filter.xml.input.SourceInputSource;
import org.xwiki.model.reference.EntityReference;

@Component(hints={"xwiki+xar/1.6", "xwiki+xar/1.5", "xwiki+xar/1.4", "xwiki+xar/1.3", "xwiki+xar/1.2", "xwiki+xar/1.1"})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XARInputFilterStream
extends AbstractBeanInputFilterStream<XARInputProperties, XARInputFilter> {
    @Inject
    private Provider<WikiReader> wikiReaderProvider;
    @Inject
    private Provider<DocumentLocaleReader> documentLocaleReaderProvider;

    public void close() throws IOException {
        ((XARInputProperties)((Object)this.properties)).getSource().close();
    }

    protected void read(Object filter, XARInputFilter proxyFilter) throws FilterException {
        InputSource inputSource = ((XARInputProperties)((Object)this.properties)).getSource();
        if (((XARInputProperties)((Object)this.properties)).isForceDocument() || inputSource instanceof ReaderInputSource || inputSource instanceof SourceInputSource) {
            this.readDocument(filter, proxyFilter);
        } else if (inputSource instanceof InputStreamInputSource) {
            InputStream stream;
            try {
                stream = ((InputStreamInputSource)inputSource).getInputStream();
            }
            catch (IOException e) {
                throw new FilterException("Failed to get input stream", (Throwable)e);
            }
            try {
                Boolean iszip = this.isZip(stream);
                if (iszip == Boolean.FALSE) {
                    this.readDocument(filter, proxyFilter);
                }
                this.readXAR(filter, proxyFilter);
            }
            catch (IOException e) {
                throw new FilterException("Failed to read input stream", (Throwable)e);
            }
            finally {
                try {
                    inputSource.close();
                }
                catch (IOException e) {
                    throw new FilterException("Failed to close the source", (Throwable)e);
                }
            }
        } else {
            throw new FilterException(String.format("Unsupported input source of type [%s]", inputSource.getClass()));
        }
    }

    private void readXAR(Object filter, XARInputFilter proxyFilter) throws FilterException {
        WikiReader wikiReader = (WikiReader)this.wikiReaderProvider.get();
        wikiReader.setProperties((XARInputProperties)((Object)this.properties));
        try {
            wikiReader.read(filter, proxyFilter);
        }
        catch (Exception e) {
            throw new FilterException("Failed to read XAR package", (Throwable)e);
        }
    }

    protected void readDocument(Object filter, XARInputFilter proxyFilter) throws FilterException {
        DocumentLocaleReader documentReader = (DocumentLocaleReader)this.documentLocaleReaderProvider.get();
        documentReader.setProperties((XARInputProperties)((Object)this.properties));
        try {
            documentReader.read(filter, proxyFilter);
        }
        catch (Exception e) {
            throw new FilterException("Failed to read XAR XML document", (Throwable)e);
        }
        if (documentReader.getSentSpaceReference() != null) {
            for (EntityReference space = documentReader.getSentSpaceReference(); space != null; space = space.getParent()) {
                proxyFilter.endWikiSpace(space.getName(), FilterEventParameters.EMPTY);
            }
        }
    }

    private Boolean isZip(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            return null;
        }
        byte[] signature = new byte[12];
        stream.mark(signature.length);
        int signatureLength = stream.read(signature);
        stream.reset();
        return ZipArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }
}

