/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.input.AbstractReader;
import org.xwiki.filter.xar.internal.input.ClassPropertyReader;
import org.xwiki.filter.xar.internal.input.ClassReader;
import org.xwiki.filter.xar.internal.input.XARInputFilter;
import org.xwiki.xar.internal.XarObjectPropertySerializerManager;

public class AbstractWikiObjectPropertyReader
extends AbstractReader {
    @Inject
    private XarObjectPropertySerializerManager propertySerializerManager;

    public WikiObjectProperty readObjectProperty(XMLStreamReader xmlReader, XARInputProperties properties, ClassReader.WikiClass wikiClass) throws XMLStreamException, FilterException {
        ClassPropertyReader.WikiClassProperty classProperty;
        xmlReader.nextTag();
        WikiObjectProperty property = new WikiObjectProperty();
        property.name = xmlReader.getLocalName();
        String type = wikiClass != null ? ((classProperty = wikiClass.properties.get(property.name)) != null ? classProperty.type : null) : properties.getObjectPropertyType();
        try {
            property.value = this.propertySerializerManager.getPropertySerializer(type).read(xmlReader);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to get a property parser", (Throwable)e);
        }
        property.parameters.put((Object)"type", (Object)type);
        xmlReader.nextTag();
        return property;
    }

    public class WikiObjectProperty {
        public String name;
        public Object value;
        public FilterEventParameters parameters = new FilterEventParameters();

        public void send(XARInputFilter proxyFilter) throws FilterException {
            proxyFilter.onWikiObjectProperty(this.name, this.value, this.parameters);
        }
    }
}

