/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.filter.FilterException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.xml.stax.StAXUtils;

public abstract class AbstractReader {
    @Inject
    protected Logger logger;

    protected <T> T convert(Class<?> type, String source) throws FilterException {
        Object value = source;
        if (type == Locale.class) {
            value = this.toLocale(source);
        } else if (type == Date.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? new Date(Long.parseLong(source)) : null;
        } else if (type == Boolean.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? Boolean.valueOf(Boolean.parseBoolean(source)) : null;
        } else if (type == Syntax.class) {
            if (StringUtils.isNotEmpty((CharSequence)source)) {
                try {
                    value = Syntax.valueOf((String)source);
                }
                catch (ParseException e) {
                    throw new FilterException(String.format("Failed to create Syntax istance for [%s]", source), (Throwable)e);
                }
            } else {
                value = null;
            }
        } else if (type == Integer.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? Integer.valueOf(Integer.parseInt(source)) : null;
        }
        return (T)value;
    }

    protected Locale toLocale(String value) {
        Locale locale = null;
        if (value != null) {
            locale = value.length() == 0 ? Locale.ROOT : LocaleUtils.toLocale((String)value);
        }
        return locale;
    }

    protected void unknownElement(XMLStreamReader xmlReader) throws FilterException {
        this.logger.warn("Unknown element [{}] at line [{}]", (Object)xmlReader.getLocalName(), (Object)xmlReader.getLocation().getLineNumber());
        try {
            StAXUtils.skipElement((XMLStreamReader)xmlReader);
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to skip element", (Throwable)e);
        }
    }
}

