/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.input;

import org.xwiki.filter.xml.input.XMLInputProperties;
import org.xwiki.model.reference.EntityReferenceSet;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyHidden;
import org.xwiki.properties.annotation.PropertyName;

public class XARInputProperties
extends XMLInputProperties {
    private EntityReferenceSet entities;
    private SourceType sourceType;
    private boolean withHistory = true;
    private boolean withExtension = true;
    private String objectPropertyType;

    @PropertyName(value="Entities")
    @PropertyDescription(value="The entities to take into account or skip")
    @PropertyHidden
    public EntityReferenceSet getEntities() {
        return this.entities;
    }

    public void setEntities(EntityReferenceSet entities) {
        this.entities = entities;
    }

    @PropertyName(value="With history")
    @PropertyDescription(value="Indicate if events should be generated for history")
    public boolean isWithHistory() {
        return this.withHistory;
    }

    public void setWithHistory(boolean withHistory) {
        this.withHistory = withHistory;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    @PropertyName(value="Force document")
    @PropertyDescription(value="Force considering the input stream as a document")
    @Deprecated
    public boolean isForceDocument() {
        return this.sourceType == SourceType.DOCUMENT;
    }

    @Deprecated
    public void setForceDocument(boolean forceDocument) {
        if (forceDocument) {
            this.sourceType = SourceType.DOCUMENT;
        }
    }

    @PropertyName(value="With extensions")
    @PropertyDescription(value="Indicates if extension event should be generated if possible")
    public boolean isWithExtension() {
        return this.withExtension;
    }

    public void setWithExtension(boolean withExtension) {
        this.withExtension = withExtension;
    }

    @PropertyName(value="Object property type")
    @PropertyDescription(value="The type of the object property to parse (when the input is an object property)")
    public String getObjectPropertyType() {
        return this.objectPropertyType;
    }

    public void setObjectPropertyType(String objectPropertyType) {
        this.objectPropertyType = objectPropertyType;
    }

    public static enum SourceType {
        XAR,
        DOCUMENT,
        ATTACHMENT,
        CLASS,
        CLASSPROPERTY,
        OBJECT,
        OBJECTPROPERTY;

    }
}

