/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.output;

import java.io.IOException;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.event.extension.ExtensionFilter;
import org.xwiki.filter.event.model.WikiFilter;
import org.xwiki.filter.instance.output.ExtensionInstanceOutputProperties;
import org.xwiki.filter.output.AbstractBeanOutputFilterStream;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="xwiki+instance+extension")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ExtensionInstanceOutputFilterStream
extends AbstractBeanOutputFilterStream<ExtensionInstanceOutputProperties>
implements ExtensionFilter,
WikiFilter {
    private static final String WIKINAMESPACE = "wiki:";
    @Inject
    private LocalExtensionRepository localRepository;
    @Inject
    private ExtensionRepositoryManager extensionRepository;
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private ModelContext modelContext;
    @Inject
    private ExtensionFactory factory;
    @Inject
    private Logger logger;
    private Stack<String> currentNamespace = new Stack();

    public void close() throws IOException {
    }

    private String getCurrentNamespace() {
        if (!this.currentNamespace.isEmpty()) {
            return this.currentNamespace.peek();
        }
        String namespace = null;
        EntityReference currentEntityReference = this.modelContext.getCurrentEntityReference();
        if (currentEntityReference != null) {
            namespace = WIKINAMESPACE + currentEntityReference.extractReference(EntityType.WIKI).getName();
        }
        return namespace;
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentNamespace.push(WIKINAMESPACE + name);
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentNamespace.pop();
    }

    public void beginNamespace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentNamespace.push(name);
    }

    public void endNamespace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentNamespace.pop();
    }

    public void beginExtension(String id, String version, FilterEventParameters parameters) throws FilterException {
    }

    public void endExtension(String id, String version, FilterEventParameters parameters) throws FilterException {
        ExtensionId extensionId = new ExtensionId(id, this.factory.getVersion(version));
        try {
            LocalExtension localExtension = this.localRepository.getLocalExtension(extensionId);
            if (localExtension == null) {
                Extension extension;
                try {
                    extension = this.extensionRepository.resolve(extensionId);
                }
                catch (ResolveException e) {
                    this.logger.debug("Can't find extension [{}]", (Object)extensionId, (Object)e);
                    return;
                }
                localExtension = this.localRepository.storeExtension(extension);
            }
            String namespace = this.getCurrentNamespace();
            if (this.installedRepository.getInstalledExtension(localExtension.getId().getId(), namespace) == null) {
                for (ExtensionId feature : localExtension.getExtensionFeatures()) {
                    if (this.installedRepository.getInstalledExtension(feature.getId(), namespace) == null) continue;
                    return;
                }
            } else {
                return;
            }
            this.installedRepository.installExtension(localExtension, namespace, false);
        }
        catch (Exception e) {
            this.logger.error("Failed to register extenion [{}] from the XAR", (Object)extensionId, (Object)e);
        }
    }
}

