/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.instance.input.InstanceInputEventGenerator;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractInstanceInputEventGenerator<F>
implements InstanceInputEventGenerator,
Initializable {
    @Inject
    private FilterDescriptorManager filterDescriptorManager;
    private List<Class<?>> filerInterfaces;
    protected Map<String, Object> properties;
    protected Object filter;
    protected F proxyFilter;
    protected String currentWiki;
    protected Stack<String> currentSpaces = new Stack();
    protected EntityReference currentReference;
    protected FilterStreamDescriptor descriptor;

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractInstanceInputEventGenerator.class, this.getClass());
        this.filerInterfaces = Arrays.asList(ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[0]));
    }

    @Override
    public FilterStreamDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(FilterStreamDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        return this.filerInterfaces;
    }

    @Override
    public void setWikiFarmParameters(FilterEventParameters parameters) throws FilterException {
    }

    @Override
    public void setWikiParameters(String name, FilterEventParameters parameters) throws FilterException {
    }

    @Override
    public void setWikiSpaceParameters(String name, FilterEventParameters parameters) throws FilterException {
    }

    @Override
    public void setWikiDocumentParameters(String name, FilterEventParameters parameters) throws FilterException {
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void setFilter(Object filter) {
        this.filter = filter;
        this.proxyFilter = this.filterDescriptorManager.createFilterProxy(filter, this.filerInterfaces.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    public void beginWikiFarm(FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiFarm(FilterEventParameters parameters) throws FilterException {
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentWiki = name;
        this.currentReference = new EntityReference(this.currentWiki, EntityType.WIKI);
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentWiki = null;
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentSpaces.push(name);
        this.currentReference = new EntityReference(name, EntityType.SPACE, this.currentReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentSpaces.pop();
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentReference = new EntityReference(name, EntityType.DOCUMENT, this.currentReference);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentReference = this.currentReference.getParent();
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
    }

    public void beginUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }

    public void endUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }

    public void onUnknwon(String id, FilterEventParameters parameters) throws FilterException {
    }
}

