/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.security;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.xwiki.extension.version.Version;
import org.xwiki.text.XWikiToStringBuilder;

public class SecurityVulnerabilityDescriptor {
    private String id;
    private Set<String> aliases;
    private String url;
    private double score;
    private Version fixVersion;
    private boolean safe;
    private String reviews;

    public SecurityVulnerabilityDescriptor setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SecurityVulnerabilityDescriptor setURL(String url) {
        this.url = url;
        return this;
    }

    public String getURL() {
        return this.url;
    }

    public SecurityVulnerabilityDescriptor setSeverityScore(String vector) {
        if (StringUtils.isNotEmpty((CharSequence)vector)) {
            this.score = CvssVector.parseVector((String)vector).getBaseScore();
        }
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public SecurityVulnerabilityDescriptor setScore(double score) {
        this.score = score;
        return this;
    }

    public Version getFixVersion() {
        return this.fixVersion;
    }

    public SecurityVulnerabilityDescriptor setFixVersion(Version fixVersion) {
        this.fixVersion = fixVersion;
        return this;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public SecurityVulnerabilityDescriptor setSafe(boolean safe) {
        this.safe = safe;
        return this;
    }

    public String getReviews() {
        return this.reviews;
    }

    public SecurityVulnerabilityDescriptor setReviews(String reviews) {
        this.reviews = reviews;
        return this;
    }

    public Set<String> getAliases() {
        if (this.aliases == null) {
            this.aliases = new HashSet<String>();
        }
        return this.aliases;
    }

    public SecurityVulnerabilityDescriptor setAliases(Set<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityVulnerabilityDescriptor that = (SecurityVulnerabilityDescriptor)o;
        return new EqualsBuilder().append(this.score, that.score).append((Object)this.id, (Object)that.id).append((Object)this.url, (Object)that.url).append((Object)this.fixVersion, (Object)that.fixVersion).append(this.safe, that.safe).append((Object)this.reviews, (Object)that.reviews).append(this.aliases, that.aliases).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.url).append(this.score).append((Object)this.fixVersion).append(this.safe).append((Object)this.reviews).append(this.aliases).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("id", (Object)this.id).append("url", (Object)this.url).append("score", this.score).append("fixVersion", (Object)this.fixVersion).append("safe", this.safe).append("reviews", (Object)this.reviews).append("aliases", this.aliases).toString();
    }
}

