/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.security;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.index.security.SecurityVulnerabilityDescriptor;
import org.xwiki.text.XWikiToStringBuilder;

public class ExtensionSecurityAnalysisResult {
    private List<SecurityVulnerabilityDescriptor> securityVulnerabilities;
    private String advice;
    private boolean coreExtension;

    public ExtensionSecurityAnalysisResult setResults(List<SecurityVulnerabilityDescriptor> securityVulnerabilities) {
        this.securityVulnerabilities = securityVulnerabilities;
        return this;
    }

    public List<SecurityVulnerabilityDescriptor> getSecurityVulnerabilities() {
        return this.securityVulnerabilities;
    }

    public String getAdvice() {
        return this.advice;
    }

    public ExtensionSecurityAnalysisResult setAdvice(String advice) {
        this.advice = advice;
        return this;
    }

    public Double getMaxCVSS() {
        if (this.securityVulnerabilities != null) {
            return this.securityVulnerabilities.stream().max(Comparator.comparingDouble(SecurityVulnerabilityDescriptor::getScore)).map(SecurityVulnerabilityDescriptor::getScore).orElse(null);
        }
        return null;
    }

    public boolean isCoreExtension() {
        return this.coreExtension;
    }

    public ExtensionSecurityAnalysisResult setCoreExtension(boolean coreExtension) {
        this.coreExtension = coreExtension;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionSecurityAnalysisResult that = (ExtensionSecurityAnalysisResult)o;
        return new EqualsBuilder().append(this.securityVulnerabilities, that.securityVulnerabilities).append((Object)this.advice, (Object)that.advice).append(this.coreExtension, that.coreExtension).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.securityVulnerabilities).append((Object)this.advice).append(this.coreExtension).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("securityVulnerabilities", this.securityVulnerabilities).append("advice", (Object)this.advice).append("coreExtension", this.coreExtension).toString();
    }
}

