/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.index.internal.ExtensionIndexSolrUtil;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;

@Component
@Singleton
@Named(value="R150501000XWIKI21136")
public class R150501000XWIKI21136DataMigration
implements HibernateDataMigration {
    public static final String HINT = "R150501000XWIKI21136";
    @Inject
    private Execution execution;
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private ExtensionIndexSolrUtil extensionIndexSolrUtil;

    public String getName() {
        return HINT;
    }

    public String getDescription() {
        return "Update the installedNamespaces of indexed extensions, because they were not updated on upgrade previously";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(150501000);
    }

    public void migrate() throws DataMigrationException {
        try {
            this.migrateInstalledExtensions(this.solr.getClient("extension_index"));
        }
        catch (SolrException e) {
            throw new DataMigrationException("Failed to get the extension index Solr core", (Throwable)e);
        }
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return this.getXWikiContext().isMainWiki();
    }

    public String getPreHibernateLiquibaseChangeLog() {
        return null;
    }

    public String getLiquibaseChangeLog() {
        return null;
    }

    private XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    private void migrateInstalledExtensions(SolrClient client) throws SolrException {
        try {
            int batchSize = 10000;
            int start = 0;
            SolrDocumentList results = this.updateBatch(client, batchSize, start);
            while (results.size() >= batchSize) {
                results = this.updateBatch(client, batchSize, ++start);
            }
            client.commit();
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException("Failed to update the namespaces of installed extensions", (Exception)e);
        }
    }

    private SolrDocumentList updateBatch(SolrClient client, int batchSize, int start) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery().setRows(Integer.valueOf(batchSize)).setStart(Integer.valueOf(start)).setFilterQueries(new String[]{"installedNamespaces:[* TO *]"}).setFields(new String[]{"id"});
        QueryResponse query = client.query((SolrParams)solrQuery);
        SolrDocumentList results = query.getResults();
        for (SolrDocument doc : results) {
            SolrInputDocument updateDocument = new SolrInputDocument();
            String solrId = this.solrUtils.getId(doc);
            this.solrUtils.set("id", (Object)solrId, updateDocument);
            this.extensionIndexSolrUtil.updateInstalledState(this.extensionIndexSolrUtil.fromSolrId(solrId), updateDocument);
            client.add(updateDocument);
        }
        return results;
    }
}

