/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionContext;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.RemoteExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.index.internal.ExtensionIndexStore;
import org.xwiki.extension.index.internal.job.DefaultExtensionIndexStatus;
import org.xwiki.extension.index.internal.job.ExtensionIndexRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.ExtensionPlanTree;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.VersionUtils;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.Job;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.platform.flavor.FlavorManager;
import org.xwiki.search.solr.SolrUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="extension.index")
public class ExtensionIndexJob
extends AbstractJob<ExtensionIndexRequest, DefaultExtensionIndexStatus>
implements GroupedJob {
    public static final String JOB_TYPE = "extension.index";
    private static final int SEARCH_BATCH_SIZE = 100;
    private static final JobGroupPath GROUP_PATH = new JobGroupPath("extension.index", null);
    @Inject
    private ExtensionIndexStore indexStore;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private LocalExtensionRepository localExtensions;
    @Inject
    private CoreExtensionRepository coreExtensions;
    @Inject
    private JobProgressManager progress;
    @Inject
    private ExtensionContext extensionContext;
    @Inject
    private ExtensionManagerConfiguration configuration;
    @Inject
    private InstalledExtensionRepository installedExtensions;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private FlavorManager flavors;
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    @Named(value="installplan")
    private Provider<Job> installPlanJobProvider;
    private Collection<String> invalidFlavors;

    public JobGroupPath getGroupPath() {
        return GROUP_PATH;
    }

    protected void jobStarting() {
        Thread.currentThread().setPriority(4);
        this.extensionContext.pushSession();
        super.jobStarting();
    }

    protected void jobFinished(Throwable error) {
        try {
            super.jobFinished(error);
        }
        finally {
            this.extensionContext.popSession();
            Thread.currentThread().setPriority(5);
        }
    }

    public String getType() {
        return JOB_TYPE;
    }

    protected DefaultExtensionIndexStatus createNewStatus(ExtensionIndexRequest request) {
        return new DefaultExtensionIndexStatus(request, this.observationManager, this.loggerManager);
    }

    protected void runInternal() throws Exception {
        this.invalidFlavors = this.flavors.getKnownInvalidFlavors();
        Map<String, SortedSet<Version>> indexedExtensions = this.getIndexedExtensions();
        this.progress.pushLevelProgress(4, (Object)this);
        this.progress.startStep((Object)this);
        if (((ExtensionIndexRequest)this.getRequest()).isLocalExtensionsEnabled()) {
            // empty if block
        }
        this.progress.startStep((Object)this);
        if (((ExtensionIndexRequest)this.getRequest()).isRemoteExtensionsEnabled()) {
            this.addRemoteExtensions(indexedExtensions);
        }
        HashMap<String, Set<Namespace>> missingExtension = new HashMap<String, Set<Namespace>>();
        this.progress.startStep((Object)this);
        this.validateLastExtensions(indexedExtensions, missingExtension);
        this.progress.startStep((Object)this);
        if (!missingExtension.isEmpty()) {
            this.validateOldExtensions(missingExtension, indexedExtensions);
        }
    }

    private void validateLastExtensions(Map<String, SortedSet<Version>> indexedExtensions, Map<String, Set<Namespace>> missingExtension) {
        this.progress.pushLevelProgress(((ExtensionIndexRequest)this.getRequest()).getNamespaces().size(), ((ExtensionIndexRequest)this.getRequest()).getNamespaces());
        for (Namespace namespace : ((ExtensionIndexRequest)this.getRequest()).getNamespaces()) {
            this.progress.startStep(((ExtensionIndexRequest)this.getRequest()).getNamespaces());
            this.validateExtensions(namespace, indexedExtensions, missingExtension);
        }
        this.progress.popLevelProgress(((ExtensionIndexRequest)this.getRequest()).getNamespaces());
    }

    private void validateOldExtensions(Map<String, Set<Namespace>> missingExtension, Map<String, SortedSet<Version>> indexedExtensions) throws SolrServerException, IOException {
        this.progress.pushLevelProgress(missingExtension.size(), missingExtension);
        for (Map.Entry<String, Set<Namespace>> entry : missingExtension.entrySet()) {
            this.progress.startStep(((ExtensionIndexRequest)this.getRequest()).getNamespaces());
            this.validateOlderExtensions(entry.getKey(), entry.getValue(), indexedExtensions);
        }
        this.progress.popLevelProgress(missingExtension);
    }

    private void add(ExtensionId extension, Map<String, SortedSet<Version>> extensions) {
        extensions.computeIfAbsent(extension.getId(), key -> new TreeSet()).add(extension.getVersion());
    }

    private Map<String, SortedSet<Version>> getIndexedExtensions() throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        Set<ExtensionId> extensionIds = this.indexStore.searchExtensionIds(solrQuery);
        HashMap<String, SortedSet<Version>> extensions = new HashMap<String, SortedSet<Version>>(extensionIds.size());
        for (ExtensionId extensionId : extensionIds) {
            this.add(extensionId, extensions);
        }
        return extensions;
    }

    private void validateOlderExtensions(String extensionId, Set<Namespace> namespaces, Map<String, SortedSet<Version>> indexedExtensions) throws SolrServerException, IOException {
        boolean updated = false;
        SortedSet<Version> indexedVersions = indexedExtensions.get(extensionId);
        Version compatibleVersion = this.indexStore.getCompatibleVersion(extensionId, null);
        for (Namespace namespace : namespaces) {
            try {
                if (compatibleVersion != null && this.indexStore.isCompatible(new ExtensionId(extensionId, compatibleVersion), namespace.serialize()) != null || compatibleVersion != null) continue;
                updated |= this.validateOldExtension(extensionId, namespace, indexedVersions);
            }
            catch (Exception e) {
                this.logger.error("Failed to validate extensions [{}] on namespace [{}]", new Object[]{extensionId, namespace, e});
            }
        }
        if (updated) {
            this.indexStore.commit();
        }
    }

    private Version getStopVersion(String extensionId, String namespace) {
        InstalledExtension installedExtension = this.installedExtensions.getInstalledExtension(extensionId, namespace);
        Version stopVersion = installedExtension != null ? installedExtension.getId().getVersion() : null;
        return stopVersion;
    }

    private boolean validateExtension(String extensionId, Namespace namespace, SortedSet<Version> indexedVersions, Map<String, Set<Namespace>> missingExtensions) throws SolrServerException, IOException {
        if (this.coreExtensions.exists(extensionId) || this.invalidFlavors.contains(extensionId)) {
            return false;
        }
        String namespaceString = namespace.serialize();
        Version stopVersion = this.getStopVersion(extensionId, namespaceString);
        VersionConstraint recommendedVersionConstraint = this.configuration.getRecomendedVersionConstraint(extensionId);
        Version recommendedVersion = VersionUtils.getUniqueVersion((VersionConstraint)recommendedVersionConstraint);
        if (recommendedVersion != null && recommendedVersion.equals(stopVersion)) {
            return false;
        }
        if (recommendedVersion != null) {
            return this.validateRecommendedVersion(extensionId, recommendedVersion, namespace, indexedVersions);
        }
        ExtensionId tryId = new ExtensionId(extensionId, indexedVersions.last());
        if (this.isValidated(tryId, namespaceString)) {
            return false;
        }
        Extension validExtension = this.tryInstall(tryId, namespace);
        if (validExtension != null) {
            this.addSearchableCompatibleExtension(validExtension, namespace, indexedVersions);
            return true;
        }
        missingExtensions.computeIfAbsent(extensionId, key -> new HashSet()).add(namespace);
        this.indexStore.updateCompatible(tryId, namespace.serialize(), null, (Boolean)true);
        return true;
    }

    private boolean validateRecommendedVersion(String extensionId, Version recommendedVersion, Namespace namespace, SortedSet<Version> indexedVersions) throws SolrServerException, IOException {
        ExtensionId recommendedExtensionId = new ExtensionId(extensionId, recommendedVersion);
        ExtensionId lastExtensionId = new ExtensionId(extensionId, indexedVersions.last());
        if (this.isValidated(recommendedExtensionId, namespace.serialize()) || this.isValidated(lastExtensionId, namespace.serialize())) {
            return false;
        }
        ExtensionId tryId = this.extensionManager.exists(recommendedExtensionId) ? recommendedExtensionId : lastExtensionId;
        return this.validate(tryId, namespace, indexedVersions);
    }

    private boolean isAllowRootModications(Namespace namespace) {
        return namespace == null || namespace.equals((Object)Namespace.ROOT) || namespace.getType().endsWith("wiki") && this.wikis.isMainWiki(namespace.getValue());
    }

    private boolean isValidated(ExtensionId extensionId, String namespace) throws SolrServerException, IOException {
        return this.indexStore.isCompatible(extensionId, namespace) != null;
    }

    private boolean validateOldExtension(String extensionId, Namespace namespace, Collection<Version> versions, Version stopVersion, SortedSet<Version> indexedVersions) throws SolrServerException, IOException {
        ArrayList<Version> versionList = versions instanceof List ? (ArrayList<Version>)versions : new ArrayList<Version>(versions);
        ListIterator it = versionList.listIterator(versionList.size());
        while (it.hasPrevious()) {
            Version version = (Version)it.previous();
            if (stopVersion != null && stopVersion.compareTo((Object)version) >= 0) break;
            ExtensionId tryId = new ExtensionId(extensionId, version);
            Boolean compatible = this.indexStore.isCompatible(tryId, namespace.serialize());
            if (compatible != null) {
                return false;
            }
            if (!this.validate(tryId, namespace, indexedVersions)) continue;
            return true;
        }
        return false;
    }

    private boolean validate(ExtensionId extensionId, Namespace namespace, SortedSet<Version> indexedVersions) throws SolrServerException, IOException {
        Extension validExtension = this.tryInstall(extensionId, namespace);
        if (validExtension != null) {
            this.addSearchableCompatibleExtension(validExtension, namespace, indexedVersions);
            return true;
        }
        if (this.indexStore.exists(extensionId)) {
            this.indexStore.updateCompatible(extensionId, namespace.serialize(), null, (Boolean)true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extension tryInstall(ExtensionId extensionId, Namespace namespace) {
        InstallRequest planRequest = new InstallRequest(this.getRequest());
        planRequest.setId((List)null);
        planRequest.setVerbose(false);
        planRequest.setStatusLogIsolated(Boolean.valueOf(true));
        planRequest.addExtension(extensionId);
        planRequest.setRootModificationsAllowed(this.isAllowRootModications(namespace));
        if (namespace != null) {
            planRequest.addNamespace(namespace.serialize());
        }
        Job job = (Job)this.installPlanJobProvider.get();
        job.initialize((Request)planRequest);
        ((DefaultExtensionIndexStatus)this.getStatus()).ignoreLogs(true);
        try {
            job.run();
        }
        finally {
            ((DefaultExtensionIndexStatus)this.getStatus()).ignoreLogs(false);
        }
        if (job.getStatus().getError() == null) {
            ExtensionPlanTree tree = ((ExtensionPlan)job.getStatus()).getTree();
            ExtensionPlanNode node = (ExtensionPlanNode)IterableUtils.get((Iterable)tree, (int)(tree.size() - 1));
            return node.getAction().getExtension();
        }
        return null;
    }

    private void addSearchableCompatibleExtension(Extension validExtension, Namespace namespace, SortedSet<Version> indexedVersions) throws SolrServerException, IOException {
        if (!indexedVersions.contains(validExtension.getId().getVersion())) {
            this.indexStore.add(validExtension, false);
            if (!indexedVersions.isEmpty()) {
                this.indexStore.update(validExtension.getId(), indexedVersions.last());
            }
            indexedVersions.add(validExtension.getId().getVersion());
        }
        for (Version version : indexedVersions) {
            this.indexStore.updateCompatible(new ExtensionId(validExtension.getId().getId(), version), namespace.serialize(), (Boolean)version.equals(validExtension.getId().getVersion()), null);
        }
    }

    private boolean validateOldExtension(String extensionId, Namespace namespace, SortedSet<Version> indexedVersions) throws SolrServerException, IOException {
        String namespaceString = namespace.serialize();
        Version stopVersion = this.getStopVersion(extensionId, namespaceString);
        TreeSet<Version> versions = new TreeSet<Version>();
        for (LocalExtension localExtension : this.localExtensions.getLocalExtensionVersions(extensionId)) {
            versions.add(localExtension.getId().getVersion());
        }
        try {
            CollectionUtils.addAll(versions, (Iterable)this.repositoryManager.resolveVersions(extensionId, 0, -1));
        }
        catch (ResolveException e) {
            this.logger.debug("Failed to get available version on remote repositories", (Throwable)e);
        }
        versions.remove(indexedVersions.last());
        return this.validateOldExtension(extensionId, namespace, versions, stopVersion, indexedVersions);
    }

    private void validateExtensions(Namespace namespace, Map<String, SortedSet<Version>> indexedExtensions, Map<String, Set<Namespace>> missingExtensions) {
        this.progress.pushLevelProgress(indexedExtensions.size(), indexedExtensions);
        for (Map.Entry<String, SortedSet<Version>> entry : indexedExtensions.entrySet()) {
            this.progress.startStep(indexedExtensions);
            String extensionId = entry.getKey();
            SortedSet<Version> indexedVersions = entry.getValue();
            try {
                if (!this.validateExtension(extensionId, namespace, indexedVersions, missingExtensions)) continue;
                this.indexStore.commit();
            }
            catch (Exception e) {
                this.logger.error("Failed to validate extension with if [{}] on namespace [{}]", new Object[]{extensionId, namespace, e});
            }
        }
        this.progress.popLevelProgress(indexedExtensions);
    }

    private void addLocalExtensions(Map<String, SortedSet<Version>> indexedExtensions) throws SearchException, SolrServerException, IOException {
        boolean updated = false;
        IterableResult extensions = this.localExtensions.search("", 0, -1);
        for (Extension extension : extensions) {
            if (this.invalidFlavors.contains(extension.getId().getId()) || extension.getId().getVersion().getType() != Version.Type.STABLE || this.indexStore.exists(extension.getId(), true)) continue;
            this.indexStore.add(extension, true);
            updated = true;
            ((DefaultExtensionIndexStatus)this.getStatus()).setExtensionAdded(true);
            this.add(extension.getId(), indexedExtensions);
        }
        if (updated) {
            this.indexStore.commit();
        }
    }

    private void addRemoteExtensions(Map<String, SortedSet<Version>> indexedExtensions) throws SolrServerException, IOException {
        boolean updated = false;
        Collection repositories = this.repositoryManager.getRepositories();
        this.progress.pushLevelProgress((Object)repositories);
        for (ExtensionRepository repository : repositories) {
            this.progress.startStep((Object)repositories);
            if (!(repository instanceof Searchable)) continue;
            Searchable searchableRepository = (Searchable)repository;
            try {
                updated |= this.addRemoteExtensions(searchableRepository, indexedExtensions);
            }
            catch (Exception e) {
                this.logger.warn("Failed to get remote extension from repository [{}]: {}", (Object)repository.getDescriptor(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        this.progress.popLevelProgress((Object)repositories);
        if (updated) {
            this.indexStore.commit();
        }
    }

    private boolean addRemoteExtensions(Searchable searchableRepository, Map<String, SortedSet<Version>> indexedExtensions) throws SearchException, SolrServerException, IOException {
        boolean updated = false;
        int offset = 0;
        while (true) {
            IterableResult result = searchableRepository.search("", offset, 100);
            for (Extension extension : result) {
                if (!(this.invalidFlavors.contains(extension.getId().getId()) || this.coreExtensions.exists(extension.getId()) || this.localExtensions.exists(extension.getId()) || this.indexStore.exists(extension.getId()))) {
                    this.indexStore.add(extension, true);
                    this.add(extension.getId(), indexedExtensions);
                    SolrQuery solrQuery = new SolrQuery();
                    solrQuery.addFilterQuery(new String[]{"s_extensionId:" + this.solrUtils.toCompleteFilterQueryString((Object)extension.getId().getId())});
                    solrQuery.addFilterQuery(new String[]{"s_last:true"});
                    for (ExtensionId extensionid : this.indexStore.searchExtensionIds(solrQuery)) {
                        boolean last = indexedExtensions.get(extension.getId().getId()).last().equals(extensionid.getVersion());
                        if (!extensionid.getVersion().equals(extension.getId().getVersion())) {
                            this.indexStore.updateLast(extensionid, last);
                            continue;
                        }
                        if (last) continue;
                        this.indexStore.updateLast(extensionid, false);
                    }
                    updated = true;
                    ((DefaultExtensionIndexStatus)this.getStatus()).setExtensionAdded(true);
                }
                if (!(extension instanceof RemoteExtension)) continue;
                RemoteExtension remoteExtension = (RemoteExtension)extension;
                SortedSet<Version> versions = indexedExtensions.get(extension.getId().getId());
                if (versions == null) continue;
                for (Version version : versions) {
                    this.indexStore.update(new ExtensionId(extension.getId().getId(), version), remoteExtension);
                    updated = true;
                }
            }
            if (result.getSize() < 100) break;
            offset += 100;
        }
        return updated;
    }
}

