/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.extension.DefaultExtensionSupportPlans;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionComponent;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionSupportPlan;
import org.xwiki.extension.ExtensionSupportPlans;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.index.IndexedExtension;
import org.xwiki.extension.rating.ExtensionRating;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.rating.RatableExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.wrap.WrappingIndexedExtension;

public class SolrExtension
extends WrappingIndexedExtension<Extension>
implements IndexedExtension {
    private final ExtensionRepository repository;
    private final ExtensionId extensionId;
    private List<Version> versions;
    private Set<String> compatibleNamespaces = Collections.emptySet();
    private Set<String> incompatibleNamespaces = Collections.emptySet();
    private Date indexDate;
    private boolean last;
    private int totalVotes;
    private float averageVote;
    private final ExtensionRating rating = new ExtensionRating(){

        public int getTotalVotes() {
            return SolrExtension.this.totalVotes;
        }

        public float getAverageVote() {
            return SolrExtension.this.averageVote;
        }

        public RatableExtensionRepository getRepository() {
            return null;
        }
    };

    public SolrExtension(ExtensionRepository repository, ExtensionId extensionId) {
        this.repository = repository;
        this.extensionId = extensionId;
    }

    protected Extension resolveWrapped() {
        try {
            return this.repository.resolve(this.extensionId);
        }
        catch (ResolveException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public Boolean isCompatible(String namespace) {
        if (this.compatibleNamespaces != null && this.compatibleNamespaces.contains(namespace)) {
            return true;
        }
        if (this.incompatibleNamespaces != null && this.incompatibleNamespaces.contains(namespace)) {
            return false;
        }
        return null;
    }

    public void setCompatibleNamespaces(Collection<String> compatibleNamespaces) {
        this.compatibleNamespaces = compatibleNamespaces != null ? new HashSet<String>(compatibleNamespaces) : Collections.emptySet();
    }

    public void setIncompatibleNamespaces(Collection<String> incompatibleNamespaces) {
        this.incompatibleNamespaces = incompatibleNamespaces != null ? new HashSet<String>(incompatibleNamespaces) : Collections.emptySet();
    }

    public ExtensionId getId() {
        return this.extensionId;
    }

    public ExtensionRepository getRepository() {
        return this.repository;
    }

    public void setName(String name) {
        this.overwrites.put("name", name);
    }

    public void setType(String type) {
        this.overwrites.put("type", type);
    }

    public void setSummary(String summary) {
        this.overwrites.put("summary", summary);
    }

    public void setWebsite(String website) {
        this.overwrites.put("website", website);
    }

    public void setCategory(String categrory) {
        this.overwrites.put("category", categrory);
    }

    public void setAllowedNamespaces(Collection<String> namespaces) {
        this.overwrites.put("allowednamespaces", namespaces != null ? Collections.unmodifiableCollection(namespaces) : null);
    }

    public void setExtensionFeatures(Collection<ExtensionId> features) {
        this.overwrites.put("extensionfeatures", features != null ? Collections.unmodifiableCollection(features) : null);
    }

    public void setAuthors(Collection<? extends ExtensionAuthor> authors) {
        this.overwrites.put("authors", authors != null ? Collections.unmodifiableCollection(authors) : Collections.emptyList());
    }

    public void setSupportPlans(Collection<? extends ExtensionSupportPlan> supportPlans) {
        this.overwrites.put("supportplans", supportPlans != null ? new DefaultExtensionSupportPlans(supportPlans) : ExtensionSupportPlans.EMPTY);
    }

    public void setComponents(Collection<? extends ExtensionComponent> components) {
        this.overwrites.put("components", components != null ? Collections.unmodifiableCollection(components) : Collections.emptyList());
    }

    public void setRecommended(boolean recommended) {
        this.overwrites.put("recommended", recommended);
    }

    public void setSupportPlans(List<ExtensionSupportPlan> supportPlans) {
        this.overwrites.put("supportplans", supportPlans);
    }

    public ExtensionRating getRating() {
        return this.rating;
    }

    public void setTotalVotes(int totalVotes) {
        this.totalVotes = totalVotes;
    }

    public void setAverageVote(float averageVote) {
        this.averageVote = averageVote;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Date getIndexDate() {
        return this.indexDate;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public String toString() {
        return this.getId().toString();
    }
}

