/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.index.internal.ExtensionIndexStore;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="org.xwiki.extension.index.internal.ExtensionInstallListener")
@Singleton
public class ExtensionInstallListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.extension.index.internal.ExtensionInstallListener";
    @Inject
    private ExtensionIndexStore store;
    @Inject
    private Logger logger;

    public ExtensionInstallListener() {
        super(NAME, new Event[]{new ExtensionInstalledEvent(), new ExtensionUpgradedEvent(), new ExtensionUninstalledEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        try {
            if (event instanceof ExtensionUninstalledEvent) {
                this.onUninstalled(((ExtensionEvent)event).getExtensionId(), ((ExtensionEvent)event).getNamespace());
            } else if (event instanceof ExtensionInstalledEvent) {
                this.onInstalled(((ExtensionEvent)event).getExtensionId(), ((ExtensionEvent)event).getNamespace());
            } else if (event instanceof ExtensionUpgradedEvent) {
                ExtensionUpgradedEvent extensionUpgradedEvent = (ExtensionUpgradedEvent)event;
                String namespace = extensionUpgradedEvent.getNamespace();
                this.onUpgraded(extensionUpgradedEvent.getExtensionId(), (Collection)data, namespace);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the local extension store", (Throwable)e);
        }
    }

    private void onUpgraded(ExtensionId extensionId, Collection<InstalledExtension> previousExtensions, String namespace) throws SolrServerException, IOException {
        for (InstalledExtension previousExtension : previousExtensions) {
            this.store.updateInstalled(previousExtension.getId(), namespace, false);
        }
        this.store.updateInstalled(extensionId, namespace, true);
        this.store.commit();
    }

    private void onInstalled(ExtensionId extensionId, String namespace) throws SolrServerException, IOException {
        this.store.updateInstalled(extensionId, namespace, true);
        this.store.commit();
    }

    private void onUninstalled(ExtensionId extensionId, String namespace) throws SolrServerException, IOException {
        this.store.updateInstalled(extensionId, namespace, false);
        this.store.commit();
    }
}

