/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionComponent;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ExtensionSupportPlan;
import org.xwiki.extension.ExtensionSupportPlans;
import org.xwiki.extension.RemoteExtension;
import org.xwiki.extension.index.IndexedExtensionQuery;
import org.xwiki.extension.index.internal.ExtensionIndexSolrCoreInitializer;
import org.xwiki.extension.index.internal.ExtensionIndexSolrUtil;
import org.xwiki.extension.index.internal.SolrExtension;
import org.xwiki.extension.index.security.ExtensionSecurityAnalysisResult;
import org.xwiki.extension.index.security.SecurityVulnerabilityDescriptor;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.internal.converter.ExtensionSupportPlanConverter;
import org.xwiki.extension.rating.RatingExtension;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.script.service.ScriptService;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;

@Component(roles={ExtensionIndexStore.class})
@Singleton
public class ExtensionIndexStore
implements Initializable,
Disposable {
    private static final int COMMIT_BATCH_SIZE = 100;
    private static final Map<String, SearchFieldMapping> SEARCH_FIELD_MAPPING = new HashMap<String, SearchFieldMapping>();
    private static final String BOOST = "s_extensionId^10.0 name^9.0 extensionfeatures_index^8.0 summary^7.0 components_index^7.0 category^6.0 type^5.0 ";
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils utils;
    private SolrClient client;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ExtensionFactory factory;
    @Inject
    private ExtensionIndexSolrUtil extensionIndexSolrUtil;
    @Inject
    private CacheManager cacheManager;
    private Cache<SolrExtension> cache;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Set<String> modifiedIds = ConcurrentHashMap.newKeySet();
    private int documentsToStore;

    public void initialize() throws InitializationException {
        try {
            this.client = this.solr.getClient("extension_index");
        }
        catch (SolrException e) {
            throw new InitializationException("Failed to get the extension index Solr core", (Throwable)e);
        }
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("extension.index", 500));
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create the extension index cache", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.cache.dispose();
    }

    public void commit() throws SolrServerException, IOException {
        this.documentsToStore = 0;
        this.lock.writeLock().lock();
        try {
            this.client.commit();
            this.modifiedIds.forEach(arg_0 -> this.cache.remove(arg_0));
            this.modifiedIds.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addMofiedId(String id) {
        this.lock.readLock().lock();
        try {
            this.modifiedIds.add(id);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean exists(ExtensionId extensionId) throws SolrServerException, IOException {
        return this.exists(extensionId, null);
    }

    public boolean exists(ExtensionId extensionId, Boolean local) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.addFilterQuery(new String[]{"id:" + this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toSolrId(extensionId))});
        if (local != null) {
            solrQuery.addFilterQuery(new String[]{"repository:local"});
        }
        solrQuery.setRows(Integer.valueOf(0));
        return this.client.query((SolrParams)solrQuery).getResults().getNumFound() > 0L;
    }

    public void updateLast(ExtensionId extensionId, boolean last) throws SolrServerException, IOException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), document);
        this.utils.setAtomic("set", "s_last", (Object)last, document);
        this.add(document);
    }

    public void update(ExtensionId extensionId, RemoteExtension remoteExtension) throws SolrServerException, IOException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), document);
        this.utils.setAtomic("set", "supportplans", (Object)ExtensionSupportPlanConverter.toStringList((Collection)remoteExtension.getSupportPlans().getSupportPlans()), document);
        this.utils.setAtomic("set", "recommended", (Object)remoteExtension.isRecommended(), document);
        if (remoteExtension instanceof RatingExtension) {
            RatingExtension ratingExtension = (RatingExtension)remoteExtension;
            this.utils.setAtomic("set", "nbvotes", (Object)ratingExtension.getRating().getTotalVotes(), document);
            this.utils.setAtomic("set", "averagevote", (Object)Float.valueOf(ratingExtension.getRating().getAverageVote()), document);
        }
        this.add(document);
    }

    public void update(ExtensionId extensionId, ExtensionSecurityAnalysisResult result) throws SolrServerException, IOException {
        SolrInputDocument doc = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), doc);
        this.utils.setAtomic("set", "s_extensionId", (Object)extensionId.getId(), doc);
        this.utils.setAtomic("set", "version", (Object)extensionId.getVersion().getValue(), doc);
        if (!result.getSecurityVulnerabilities().isEmpty()) {
            this.utils.setAtomic("set", "security_maxCVSS", (Object)result.getMaxCVSS(), doc);
        } else {
            this.utils.setAtomic("set", "security_maxCVSS", null, doc);
        }
        Stream<String> cveIds = result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::getId);
        this.utils.setAtomic("set", "security_cveID", cveIds.collect(Collectors.toList()), doc);
        this.utils.setAtomic("set", "security_cveLink", result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::getURL).collect(Collectors.toList()), doc);
        this.utils.setAtomic("set", "security_cveCVSS", result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::getScore).collect(Collectors.toList()), doc);
        String fixVersion = result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::getFixVersion).filter(Objects::nonNull).max(Comparator.naturalOrder()).map(Version::getValue).orElse(null);
        this.utils.setAtomic("set", "security_fixVersion", (Object)fixVersion, doc);
        this.utils.setAtomic("set", "security_advice", (Object)result.getAdvice(), doc);
        this.utils.setAtomic("set", "security_cveCount", (Object)result.getSecurityVulnerabilities().size(), doc);
        this.utils.setAtomic("set", "is_core_extension", (Object)result.isCoreExtension(), doc);
        List safeMapping = result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::isSafe).collect(Collectors.toList());
        this.utils.setAtomic("set", "security_is_reviewed_safe", safeMapping, doc);
        List reviewExplanations = result.getSecurityVulnerabilities().stream().map(SecurityVulnerabilityDescriptor::getReviews).collect(Collectors.toList());
        this.utils.setAtomic("set", "security_is_safe_explanations", reviewExplanations, doc);
        this.add(doc);
        this.commit();
    }

    public boolean update(ExtensionId extensionId, Version copyVersion) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.addFilterQuery(new String[]{"id:" + this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toSolrId(new ExtensionId(extensionId.getId(), copyVersion)))});
        solrQuery.setFields(new String[]{"supportplans", "recommended", "nbvotes", "averagevote"});
        solrQuery.setRows(Integer.valueOf(1));
        QueryResponse response = this.search((SolrParams)solrQuery);
        SolrDocumentList documents = response.getResults();
        if (documents.isEmpty()) {
            return false;
        }
        SolrDocument copyDocument = (SolrDocument)documents.get(0);
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), document);
        this.utils.setAtomic("set", "supportplans", copyDocument.get((Object)"supportplans"), document);
        this.utils.setAtomic("set", "recommended", copyDocument.get((Object)"recommended"), document);
        this.utils.setAtomic("set", "recommended", copyDocument.get((Object)"recommended"), document);
        this.utils.setAtomic("set", "nbvotes", copyDocument.get((Object)"nbvotes"), document);
        this.utils.setAtomic("set", "averagevote", copyDocument.get((Object)"averagevote"), document);
        this.add(document);
        return true;
    }

    public void updateInstalled(ExtensionId extensionId, String namespace, boolean installed) throws SolrServerException, IOException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), document);
        this.utils.setAtomic(installed ? "add-distinct" : "remove", "installedNamespaces", (Object)this.extensionIndexSolrUtil.toStoredNamespace(namespace), document);
        if (installed) {
            this.updateCompatible(document, namespace, (Boolean)false, null);
        } else {
            Version compatibleVersion = this.getCompatibleVersion(extensionId.getId(), namespace);
            if (compatibleVersion == null) {
                this.updateCompatible(document, namespace, (Boolean)true, null);
            }
        }
        this.add(document);
    }

    public void updateCompatible(ExtensionId extensionId, String namespace, Boolean compatible, Boolean incompatible) throws SolrServerException, IOException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extensionId), document);
        this.updateCompatible(document, namespace, compatible, incompatible);
        this.add(document);
    }

    private void updateCompatible(SolrInputDocument document, String namespace, Boolean compatible, Boolean incompatible) {
        if (compatible != null) {
            this.utils.setAtomic(compatible != false ? "add-distinct" : "remove", "s_compatibleNamespaces", (Object)this.extensionIndexSolrUtil.toStoredNamespace(namespace), document);
        }
        if (incompatible != null) {
            this.utils.setAtomic(incompatible != false ? "add-distinct" : "remove", "s_incompatibleNamespaces", (Object)this.extensionIndexSolrUtil.toStoredNamespace(namespace), document);
        }
    }

    public Boolean isCompatible(ExtensionId extensionId, String namespace) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.addFilterQuery(new String[]{"id:" + this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toSolrId(extensionId))});
        solrQuery.setFields(new String[]{"s_compatibleNamespaces", "s_incompatibleNamespaces"});
        solrQuery.setRows(Integer.valueOf(1));
        QueryResponse response = this.search((SolrParams)solrQuery);
        SolrDocumentList documents = response.getResults();
        if (!documents.isEmpty()) {
            SolrDocument document = (SolrDocument)documents.get(0);
            String solrNamespace = this.extensionIndexSolrUtil.toStoredNamespace(namespace);
            List compatibleNamespaces = (List)this.utils.get("s_compatibleNamespaces", document);
            if (compatibleNamespaces != null && compatibleNamespaces.contains(solrNamespace)) {
                return true;
            }
            List incompatibleNamespaces = (List)this.utils.get("s_incompatibleNamespaces", document);
            if (incompatibleNamespaces != null && incompatibleNamespaces.contains(solrNamespace)) {
                return false;
            }
        }
        return null;
    }

    public void add(Extension extension, boolean last) throws SolrServerException, IOException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)this.extensionIndexSolrUtil.toSolrId(extension.getId()), document);
        this.utils.set("s_extensionId", (Object)extension.getId().getId(), document);
        this.utils.set("version", (Object)extension.getId().getVersion().getValue(), document);
        this.utils.set("type", (Object)extension.getType(), document);
        this.utils.set("repository", (Object)extension.getRepository().getDescriptor().getId(), document);
        this.utils.set("name", (Object)extension.getName(), document);
        this.utils.set("summary", (Object)extension.getSummary(), document);
        this.utils.set("website", (Object)extension.getWebSite(), document);
        if (extension.getAllowedNamespaces() != null) {
            this.utils.set("allowednamespaces", extension.getAllowedNamespaces(), document);
        }
        this.utils.set("category", (Object)extension.getCategory(), document);
        this.utils.setString("authors", extension.getAuthors(), ExtensionAuthor.class, document);
        this.utils.set("authors_index", (Collection)extension.getAuthors().stream().map(ExtensionAuthor::getName).collect(Collectors.toList()), document);
        this.utils.setString("components", extension.getComponents(), ExtensionComponent.class, document);
        for (ExtensionComponent component : extension.getComponents()) {
            document.addField(ExtensionIndexSolrCoreInitializer.toComponentFieldName(component.getRoleType()), (Object)component.getRoleHint());
        }
        this.utils.setString("extensionfeatures", extension.getExtensionFeatures(), ExtensionId.class, document);
        for (ExtensionId feature : extension.getExtensionFeatures()) {
            document.addField("extensionfeatures_index", (Object)feature.getId());
            document.addField("extensionfeatures_index", (Object)ExtensionIdConverter.toString((ExtensionId)feature));
        }
        this.utils.set("s_indexDate", (Object)new Date(), document);
        this.utils.set("s_last", (Object)last, document);
        if (extension instanceof RemoteExtension) {
            RemoteExtension remoteExtension = (RemoteExtension)extension;
            this.addSupportPlans(remoteExtension.getSupportPlans(), document);
        }
        this.extensionIndexSolrUtil.updateInstalledState(extension.getId(), document);
        this.add(document);
    }

    private void addSupportPlans(ExtensionSupportPlans supportPlans, SolrInputDocument document) {
        this.utils.setString("supportplans", (Collection)supportPlans.getSupportPlans(), ExtensionSupportPlan.class, document);
    }

    private boolean add(SolrInputDocument document) throws SolrServerException, IOException {
        this.client.add(document);
        this.addMofiedId((String)document.getFieldValue("id"));
        ++this.documentsToStore;
        if (this.documentsToStore == 100) {
            this.commit();
            return true;
        }
        return false;
    }

    public SolrExtension getSolrExtension(ExtensionId extensionId) throws SolrServerException, IOException {
        String id = this.extensionIndexSolrUtil.toSolrId(extensionId);
        SolrExtension solrExtension = (SolrExtension)((Object)this.cache.get(id));
        if (solrExtension == null) {
            solrExtension = this.toSolrExtension(this.client.getById(id), extensionId);
            this.cache.set(id, (Object)solrExtension);
        }
        return solrExtension;
    }

    public List<String> getCVEIDs(ExtensionId extensionId) throws SolrServerException, IOException {
        SolrDocument byId = this.client.getById(this.extensionIndexSolrUtil.toSolrId(extensionId));
        if (byId == null) {
            return List.of();
        }
        List securityCveID = (List)byId.get((Object)"security_cveID");
        if (securityCveID == null) {
            return List.of();
        }
        return securityCveID;
    }

    private ExtensionRepository getRepository(SolrDocument document) {
        String repositoryId = (String)this.utils.get("repository", document);
        return repositoryId != null ? this.extensionManager.getRepository(repositoryId) : null;
    }

    public ExtensionId getExtensionId(SolrDocument document) {
        return new ExtensionId((String)this.utils.get("s_extensionId", document), this.factory.getVersion((String)this.utils.get("version", document)));
    }

    public SolrExtension toSolrExtension(SolrDocument document) {
        if (document == null) {
            return null;
        }
        ExtensionId extensionId = this.getExtensionId(document);
        return this.toSolrExtension(document, extensionId);
    }

    private SolrExtension toSolrExtension(SolrDocument document, ExtensionId extensionId) {
        if (document == null) {
            return null;
        }
        SolrExtension extension = new SolrExtension(this.getRepository(document), extensionId);
        this.toSolrExtension(document, extension);
        return extension;
    }

    public void toSolrExtension(SolrDocument document, SolrExtension extension) {
        extension.setType((String)this.utils.get("type", document));
        extension.setName((String)this.utils.get("name", document));
        extension.setSummary((String)this.utils.get("summary", document));
        extension.setWebsite((String)this.utils.get("website", document));
        extension.setCategory((String)this.utils.get("category", document));
        extension.setAllowedNamespaces(this.utils.getCollection("allowednamespaces", document));
        extension.setTotalVotes((Integer)this.utils.get("nbvotes", document, (Object)0));
        extension.setAverageVote(((Float)this.utils.get("averagevote", document, (Object)Float.valueOf(0.0f))).floatValue());
        extension.setAuthors(this.utils.getCollection("authors", document, ExtensionAuthor.class));
        extension.setSupportPlans(this.utils.getCollection("supportplans", document, ExtensionSupportPlan.class));
        extension.setComponents(this.utils.getCollection("components", document, ExtensionComponent.class));
        extension.setExtensionFeatures(this.utils.getCollection("extensionfeatures", document, ExtensionId.class));
        extension.setSupportPlans(this.utils.getCollection("supportplans", document, ExtensionSupportPlan.class));
        extension.setRecommended((Boolean)this.utils.get("recommended", document, (Object)(!extension.getSupportPlans().getSupportPlans().isEmpty() ? 1 : 0)));
        extension.setLast((Boolean)this.utils.get("s_last", document, (Object)false));
        extension.setCompatibleNamespaces(this.getNamespaces("s_compatibleNamespaces", document));
        extension.setIncompatibleNamespaces(this.getNamespaces("s_incompatibleNamespaces", document));
    }

    private Collection<String> getNamespaces(String fieldName, SolrDocument document) {
        Collection storedNamespaces = this.utils.getCollection(fieldName, document);
        return this.extensionIndexSolrUtil.fromStoredNamespaces(storedNamespaces);
    }

    public IterableResult<Extension> search(ExtensionQuery query) throws SearchException {
        QueryResponse response;
        SolrQuery solrQuery = new SolrQuery();
        this.createSolrQuery(query, solrQuery);
        try {
            response = this.search((SolrParams)solrQuery);
        }
        catch (Exception e) {
            throw new SearchException("Failed to search extension for query [" + String.valueOf(query) + "]", (Throwable)e);
        }
        SolrDocumentList documents = response.getResults();
        List extensions = documents.stream().map(this::toSolrExtension).collect(Collectors.toList());
        return new CollectionIterableResult((int)documents.getNumFound(), (int)documents.getStart(), extensions);
    }

    public void createSolrQuery(ExtensionQuery query, SolrQuery solrQuery) {
        if (StringUtils.isNotBlank((CharSequence)query.getQuery())) {
            solrQuery.setQuery(query.getQuery());
            solrQuery.set("defType", new String[]{"edismax"});
            solrQuery.set("qf", new String[]{BOOST});
            solrQuery.set("f.component_macro.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(Macro.class.getName())});
            solrQuery.set("f.component_scriptservice.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(ScriptService.class.getName())});
            solrQuery.set("f.component_parser.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(Parser.class.getName())});
            solrQuery.set("f.component_renderer.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(PrintRendererFactory.class.getName())});
            solrQuery.set("f.component_blockrenderer.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(BlockRenderer.class.getName())});
            solrQuery.set("f.component_inputFilter.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(InputFilterStreamFactory.class.getName())});
            solrQuery.set("f.component_outputFilter.qf", new String[]{ExtensionIndexSolrCoreInitializer.toComponentFieldName(OutputFilterStreamFactory.class.getName())});
        }
        if (query.getOffset() > 0) {
            solrQuery.setStart(Integer.valueOf(query.getOffset()));
        }
        if (query.getLimit() > 0) {
            solrQuery.setRows(Integer.valueOf(query.getLimit()));
        } else {
            solrQuery.setRows(Integer.valueOf(Integer.MAX_VALUE));
        }
        for (ExtensionQuery.SortClause sortClause : query.getSortClauses()) {
            SearchFieldMapping fieldMapping = SEARCH_FIELD_MAPPING.get(sortClause.getField());
            String fieldName = fieldMapping != null && fieldMapping.exactField != null ? fieldMapping.exactField : sortClause.getField();
            solrQuery.addSort(fieldName, sortClause.getOrder() == ExtensionQuery.ORDER.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
        if (StringUtils.isEmpty((CharSequence)query.getQuery())) {
            solrQuery.addSort("averagevote", SolrQuery.ORDER.desc);
            solrQuery.addSort("nbvotes", SolrQuery.ORDER.desc);
        } else {
            solrQuery.addSort("score", SolrQuery.ORDER.desc);
        }
        for (ExtensionQuery.Filter filter : query.getFilters()) {
            solrQuery.addFilterQuery(new String[]{this.serializeFilter(filter)});
        }
        if (query instanceof IndexedExtensionQuery) {
            StringBuilder builder;
            IndexedExtensionQuery indexedQuery = (IndexedExtensionQuery)query;
            if (indexedQuery.getCompatible() != null) {
                builder = new StringBuilder();
                if (!indexedQuery.getCompatible().booleanValue()) {
                    builder.append('-');
                }
                builder.append("s_compatibleNamespaces");
                builder.append(':');
                builder.append('(');
                builder.append(StringUtils.join(indexedQuery.getCompatibleNamespaces().stream().map(n -> this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toStoredNamespace((Namespace)n))).iterator(), (String)" OR "));
                builder.append(')');
                solrQuery.addFilterQuery(new String[]{builder.toString()});
            }
            if (indexedQuery.getInstalled() != null) {
                builder = new StringBuilder();
                if (!indexedQuery.getInstalled().booleanValue()) {
                    builder.append('-');
                }
                builder.append("installedNamespaces");
                builder.append(':');
                builder.append('(');
                builder.append(StringUtils.join(indexedQuery.getInstalledNamespaces().stream().map(n -> this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toStoredNamespace((Namespace)n))).iterator(), (String)" OR "));
                builder.append(')');
                solrQuery.addFilterQuery(new String[]{builder.toString()});
            }
            if (indexedQuery.getCompatible() == null && indexedQuery.getInstalled() == null) {
                solrQuery.addFilterQuery(new String[]{"s_last:true"});
            }
        } else {
            solrQuery.addFilterQuery(new String[]{"s_last:true"});
        }
    }

    private String serializeFilter(ExtensionQuery.Filter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toSearchFieldName(filter));
        builder.append(':');
        if (filter.getComparison() == ExtensionQuery.COMPARISON.MATCH) {
            builder.append('*');
            builder.append(this.toFilterQueryString(filter));
            builder.append('*');
        } else {
            builder.append(this.toCompleteFilterQueryString(filter));
        }
        return builder.toString();
    }

    private String toSearchFieldName(ExtensionQuery.Filter filter) {
        SearchFieldMapping mapping = SEARCH_FIELD_MAPPING.get(filter.getField());
        if (mapping != null) {
            if (filter.getComparison() == ExtensionQuery.COMPARISON.EQUAL) {
                if (mapping.exactField != null) {
                    return mapping.exactField;
                }
            } else if (mapping.matchField != null) {
                return mapping.matchField;
            }
        }
        return filter.getField();
    }

    private String toFilterQueryString(ExtensionQuery.Filter filter) {
        SearchFieldMapping mapping = SEARCH_FIELD_MAPPING.get(filter.getField());
        if (mapping != null && mapping.type != null) {
            return this.utils.toFilterQueryString(filter.getValue(), mapping.type);
        }
        return this.utils.toFilterQueryString(filter.getValue());
    }

    private String toCompleteFilterQueryString(ExtensionQuery.Filter filter) {
        SearchFieldMapping mapping = SEARCH_FIELD_MAPPING.get(filter.getField());
        if (mapping != null && mapping.type != null) {
            return this.utils.toCompleteFilterQueryString(filter.getValue(), mapping.type);
        }
        return this.utils.toCompleteFilterQueryString(filter.getValue());
    }

    public Set<ExtensionId> searchExtensionIds(SolrQuery solrQuery) throws SolrServerException, IOException {
        if (solrQuery.getRows() == null) {
            solrQuery.setRows(Integer.valueOf(Integer.MAX_VALUE));
        }
        solrQuery.setFields(new String[]{"id"});
        QueryResponse response = this.search((SolrParams)solrQuery);
        SolrDocumentList documents = response.getResults();
        LinkedHashSet<ExtensionId> extensionId = new LinkedHashSet<ExtensionId>(documents.size());
        for (SolrDocument document : documents) {
            extensionId.add(this.extensionIndexSolrUtil.fromSolrId(this.utils.getId(document)));
        }
        return extensionId;
    }

    public QueryResponse search(SolrParams params) throws SolrServerException, IOException {
        return this.client.query(params);
    }

    public Collection<Version> getIndexedVersions(String extensionId) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setFields(new String[]{"version"});
        solrQuery.addFilterQuery(new String[]{"s_extensionId:" + this.utils.toCompleteFilterQueryString((Object)extensionId)});
        QueryResponse response = this.search((SolrParams)solrQuery);
        SolrDocumentList documents = response.getResults();
        if (documents.isEmpty()) {
            return null;
        }
        return documents.stream().map(d -> (Version)this.utils.get("version", d, Version.class)).collect(Collectors.toList());
    }

    public Version getCompatibleVersion(String extensionId) throws SolrServerException, IOException {
        return this.getCompatibleVersion(extensionId, null, false);
    }

    public Version getCompatibleVersion(String extensionId, String namespace) throws SolrServerException, IOException {
        return this.getCompatibleVersion(extensionId, namespace, true);
    }

    private Version getCompatibleVersion(String extensionId, String namespace, boolean withNamespace) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setFields(new String[]{"version"});
        solrQuery.addFilterQuery(new String[]{"s_extensionId:" + this.utils.toCompleteFilterQueryString((Object)extensionId)});
        if (withNamespace) {
            solrQuery.addFilterQuery(new String[]{"s_compatibleNamespaces:" + this.utils.toCompleteFilterQueryString((Object)this.extensionIndexSolrUtil.toStoredNamespace(namespace))});
        } else {
            solrQuery.addFilterQuery(new String[]{"s_compatibleNamespaces:[* TO *]"});
        }
        solrQuery.setRows(Integer.valueOf(1));
        QueryResponse response = this.search((SolrParams)solrQuery);
        SolrDocumentList documents = response.getResults();
        if (documents.isEmpty()) {
            return null;
        }
        return (Version)this.utils.get("version", (SolrDocument)documents.get(0), Version.class);
    }

    static {
        SEARCH_FIELD_MAPPING.put("id", new SearchFieldMapping("s_extensionId"));
        SEARCH_FIELD_MAPPING.put("author", new SearchFieldMapping("authors_index"));
        SEARCH_FIELD_MAPPING.put("authors", new SearchFieldMapping("authors_index"));
        SEARCH_FIELD_MAPPING.put("extensionfeatures", new SearchFieldMapping("extensionfeatures_index"));
        SEARCH_FIELD_MAPPING.put("extensionfeature", SEARCH_FIELD_MAPPING.get("extensionfeatures"));
        SEARCH_FIELD_MAPPING.put("feature", SEARCH_FIELD_MAPPING.get("extensionfeatures"));
        SEARCH_FIELD_MAPPING.put("features", SEARCH_FIELD_MAPPING.get("extensionfeatures"));
    }

    private static class SearchFieldMapping {
        private String exactField;
        private String matchField;
        private Type type;

        SearchFieldMapping(String solrField) {
            this(solrField, solrField);
        }

        SearchFieldMapping(String exactField, String matchField) {
            this.exactField = exactField;
            this.matchField = matchField;
        }

        SearchFieldMapping(Type type) {
            this.type = type;
        }

        SearchFieldMapping(String exactField, String matchField, Type type) {
            this.exactField = exactField;
            this.matchField = matchField;
            this.type = type;
        }
    }
}

