/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.index.ExtensionIndex;
import org.xwiki.extension.index.ExtensionIndexStatus;
import org.xwiki.extension.index.IndexedExtension;
import org.xwiki.extension.index.internal.ExtensionIndexStore;
import org.xwiki.extension.index.internal.SolrExtension;
import org.xwiki.extension.index.internal.job.ExtensionIndexJobScheduler;
import org.xwiki.extension.repository.AbstractAdvancedSearchableExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.VersionUtils;
import org.xwiki.job.JobException;

@Component
@Singleton
public class DefaultExtensionIndex
extends AbstractAdvancedSearchableExtensionRepository
implements ExtensionIndex,
Initializable {
    private static final String ID = "index";
    @Inject
    private ExtensionIndexStore store;
    @Inject
    private ExtensionIndexJobScheduler scheduler;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        this.setDescriptor((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor(ID, ID, null));
    }

    public ExtensionIndexStatus getStatus(Namespace namespace) {
        return this.scheduler.getStatus(namespace);
    }

    public ExtensionIndexStatus index(Namespace namespace) throws JobException {
        return this.scheduler.index(namespace);
    }

    public IterableResult<Extension> search(ExtensionQuery query) throws SearchException {
        return this.store.search(query);
    }

    private SolrExtension getSolrExtension(ExtensionId extensionId) {
        try {
            return this.store.getSolrExtension(extensionId);
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the extension [{}] from the index: {}", (Object)extensionId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public IndexedExtension resolve(ExtensionId extensionId) throws ResolveException {
        SolrExtension extension = this.getSolrExtension(extensionId);
        if (extension != null) {
            return extension;
        }
        throw new ExtensionNotFoundException("No extension could be found in the index for id [" + String.valueOf(extensionId) + "]");
    }

    public IndexedExtension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        ExtensionId extensionId;
        SolrExtension extension;
        Version uniqueVersion = VersionUtils.getUniqueVersion((VersionConstraint)extensionDependency.getVersionConstraint());
        if (uniqueVersion != null && (extension = this.getSolrExtension(extensionId = new ExtensionId(extensionDependency.getId(), uniqueVersion))) != null) {
            return extension;
        }
        throw new ExtensionNotFoundException("No dependency could be found in the index for id [" + String.valueOf(extensionDependency) + "]");
    }

    public boolean exists(ExtensionId extensionId) {
        try {
            return this.store.exists(extensionId);
        }
        catch (Exception e) {
            this.logger.error("Failed to check existance of extension [{}]", (Object)extensionId, (Object)e);
            return false;
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        Collection<Version> versions;
        try {
            versions = this.store.getIndexedVersions(id);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to search for extension versions", (Throwable)e);
        }
        if (versions == null) {
            throw new ExtensionNotFoundException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult(versions.size(), offset, Collections.emptyList());
        }
        return RepositoryUtils.getIterableResult((int)offset, (int)nb, versions);
    }

    public boolean isFilterable() {
        return true;
    }

    public boolean isSortable() {
        return true;
    }
}

