/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;

@Component
@Named(value="firstadminuser")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class FirstAdminUserStep
extends AbstractDistributionStep {
    public static final String ID = "firstadminuser";
    @Inject
    private transient Logger logger;
    @Inject
    private transient Provider<XWikiContext> xcontextProvider;

    public FirstAdminUserStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() == null) {
            this.setState(DistributionStep.State.COMPLETED);
            if (this.isMainWiki()) {
                try {
                    if (RightsManager.getInstance().countAllGlobalUsersOrGroups(true, null, (XWikiContext)this.xcontextProvider.get()) == 0) {
                        this.setState(null);
                    }
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to count global users", (Throwable)e);
                }
            }
        }
    }
}

