/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.distribution.internal.job.step.AbstractExtensionDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Named(value="extension.clean")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class CleanExtensionsDistributionStep
extends AbstractExtensionDistributionStep {
    public static final String ID = "extension.clean";
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Logger logger;

    public CleanExtensionsDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() == null) {
            this.setState(DistributionStep.State.COMPLETED);
            if (this.containsOrphanExtension(this.getNamespace().toString())) {
                this.setState(null);
            }
        }
    }

    private boolean containsOrphanExtension(String namespace) {
        Collection installedExtensions = this.installedRepository.getInstalledExtensions(namespace);
        for (InstalledExtension installedExtension : installedExtensions) {
            if (!installedExtension.isDependency(namespace)) continue;
            try {
                if (!(installedExtension.isInstalled(null) ? this.isMainWiki() && this.installedRepository.getBackwardDependencies(installedExtension.getId(), true).isEmpty() : this.installedRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace, true).isEmpty())) continue;
                return true;
            }
            catch (ResolveException e) {
                this.logger.warn("Failed to resolve backward dependencies for extension id [{}] on namespace [{}]", (Object)installedExtension.getId().getId(), (Object)namespace);
            }
        }
        return false;
    }
}

