/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.job.AbstractDistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;

@Component
@Named(value="distribution")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultDistributionJob
extends AbstractDistributionJob<DistributionRequest> {
    public static final String HINT = "distribution";

    @Override
    protected List<DistributionStep> createSteps() {
        ExtensionId wikiUI;
        ArrayList<DistributionStep> steps = new ArrayList<DistributionStep>();
        boolean isMainWiki = this.isMainWiki();
        if (isMainWiki) {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "firstadminuser"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get first admin step instance", (Throwable)e);
            }
        }
        this.addDefaultUIStep(steps, isMainWiki);
        this.addCleanStep(steps);
        if (isMainWiki && this.distributionConfiguration.isInteractiveDistributionWizardEnabledForWiki() && (wikiUI = this.distributionManager.getWikiUIExtensionId()) != null && StringUtils.isNotBlank((CharSequence)wikiUI.getId())) {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.defaultui.wikis"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get all in one default UI step instance", (Throwable)e);
            }
        }
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.outdatedextensions"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get outdated extensions step instance", (Throwable)e);
        }
        return steps;
    }

    private void addCleanStep(List<DistributionStep> steps) {
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.clean"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get a clean extensions step instance", (Throwable)e);
        }
    }

    private void addDefaultUIStep(List<DistributionStep> steps, boolean isMainWiki) {
        ExtensionId ui = isMainWiki ? this.getUIExtensionId() : this.distributionManager.getWikiUIExtensionId();
        if (ui != null && StringUtils.isNotBlank((CharSequence)ui.getId())) {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.defaultui"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get default UI step instance", (Throwable)e);
            }
        } else {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.flavor"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get flavor step instance", (Throwable)e);
            }
        }
    }

    @Override
    public DistributionJobStatus getPreviousStatus() {
        if (this.isMainWiki()) {
            return this.distributionManager.getPreviousFarmJobStatus();
        }
        return this.distributionManager.getPreviousWikiJobStatus(((DistributionRequest)this.getRequest()).getWiki());
    }

    @Override
    public ExtensionId getUIExtensionId() {
        if (this.isMainWiki()) {
            return this.distributionManager.getMainUIExtensionId();
        }
        return this.distributionManager.getWikiUIExtensionId();
    }
}

