/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="distribution.wiki.WikiDistributionWikiEventListener")
public class WikiDistributionWikiEventListener
extends AbstractEventListener {
    @Inject
    private DistributionManager distributionManager;

    public WikiDistributionWikiEventListener() {
        super("distribution.wiki.WikiDistributionWikiEventListener", new Event[]{new WikiCopiedEvent(), new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object o, Object context) {
        if (event instanceof WikiCopiedEvent) {
            this.onWikiCopied((WikiCopiedEvent)event);
        } else if (event instanceof WikiDeletedEvent) {
            this.onWikiDeleted((WikiDeletedEvent)event);
        }
    }

    private void onWikiCopied(WikiCopiedEvent event) {
        this.distributionManager.copyPreviousWikiJobStatus(event.getSourceWikiId(), event.getTargetWikiId());
    }

    private void onWikiDeleted(WikiDeletedEvent event) {
        this.distributionManager.deletePreviousWikiJobStatus(event.getWikiId());
    }
}

