/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.DocumentsModifiedDuringDistributionListener;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.script.safe.ScriptSafeProvider;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.text.StringUtils;

@Component
@Named(value="distribution")
@Singleton
public class DistributionInternalScriptService
implements ScriptService {
    public static final String EXTENSIONERROR_KEY = "scriptservice.distribution.error";
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private ScriptSafeProvider scriptProvider;
    @Inject
    @Named(value="xhtml/1.0")
    private BlockRenderer xhtmlRenderer;
    @Inject
    @Named(value="distribution.DocumentsModifiedDuringDistributionListener")
    private EventListener modifiedDocumentsListener;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private ContextualAuthorizationManager authorization;

    private <T> T safe(T unsafe) {
        return (T)this.scriptProvider.get(unsafe);
    }

    public DistributionManager.DistributionState getState() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return this.getState(xcontext.getWikiId());
    }

    public DistributionManager.DistributionState getState(String wiki) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki(wiki) ? this.distributionManager.getFarmDistributionState() : this.distributionManager.getWikiDistributionState(wiki);
    }

    public CoreExtension getDistributionExtension() {
        return this.distributionManager.getDistributionExtension();
    }

    public boolean hasMainDefaultUIExtension() {
        ExtensionId extension = this.distributionManager.getMainUIExtensionId();
        return extension != null && StringUtils.isNotBlank((CharSequence)extension.getId());
    }

    public boolean hasWikiDefaultUIExtension() {
        ExtensionId extension = this.distributionManager.getWikiUIExtensionId();
        return extension != null && StringUtils.isNotBlank((CharSequence)extension.getId());
    }

    public ExtensionId getUIExtensionId() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return this.getUIExtensionId(xcontext.getWikiId());
    }

    public ExtensionId getUIExtensionId(String wiki) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki(wiki) ? this.distributionManager.getMainUIExtensionId() : this.distributionManager.getWikiUIExtensionId();
    }

    public DistributionJobStatus getPreviousJobStatus() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return this.getPreviousJobStatus(xcontext.getWikiId());
    }

    public DistributionJobStatus getPreviousJobStatus(String wiki) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki(wiki) ? this.distributionManager.getPreviousFarmJobStatus() : this.distributionManager.getPreviousWikiJobStatus(wiki);
    }

    public boolean canDisplayDistributionWizard() {
        return this.distributionManager.canDisplayDistributionWizard();
    }

    public DistributionJobStatus getJobStatus() {
        DistributionJob job = this.distributionManager.getCurrentDistributionJob();
        return job != null ? job.getStatus() : null;
    }

    public String renderCurrentStepToXHTML() {
        return this.renderCurrentStepToXHTML(this.renderingContext.getTransformationId());
    }

    public String renderCurrentStepToXHTML(String transformationId) {
        JobStatus.State jobState;
        DistributionJobStatus jobStatus;
        DistributionJob job = this.distributionManager.getCurrentDistributionJob();
        if (job != null && (jobStatus = job.getStatus()) != null && ((jobState = jobStatus.getState()) == JobStatus.State.RUNNING || jobState == JobStatus.State.WAITING)) {
            Block block = job.getCurrentStep().executeInteractive();
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render(block, (WikiPrinter)printer);
            return printer.toString();
        }
        return null;
    }

    public Map<DocumentReference, DocumentsModifiedDuringDistributionListener.DocumentStatus> getModifiedDocuments() {
        return ((DocumentsModifiedDuringDistributionListener)this.modifiedDocumentsListener).getDocuments().get(((XWikiContext)this.xcontextProvider.get()).getWikiId());
    }

    public Map<String, Map<String, Map<String, Map<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>>>> getModifiedDocumentsTree() {
        Map<DocumentReference, DocumentsModifiedDuringDistributionListener.DocumentStatus> documents = ((DocumentsModifiedDuringDistributionListener)this.modifiedDocumentsListener).getDocuments().get(((XWikiContext)this.xcontextProvider.get()).getWikiId());
        TreeMap<String, Map<String, Map<String, Map<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>>>> tree = new TreeMap<String, Map<String, Map<String, Map<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>>>>();
        if (documents != null) {
            for (Map.Entry<DocumentReference, DocumentsModifiedDuringDistributionListener.DocumentStatus> document : documents.entrySet()) {
                TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus> locales;
                TreeMap<String, TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>> pages;
                DocumentReference reference = document.getKey();
                String wiki = reference.getWikiReference().getName();
                String space = reference.getLastSpaceReference().getName();
                String page = reference.getName();
                String locale = reference.getLocale() != null ? reference.getLocale().toString() : "";
                TreeMap spaces = (TreeMap)tree.get(wiki);
                if (spaces == null) {
                    spaces = new TreeMap();
                    tree.put(wiki, spaces);
                }
                if ((pages = (TreeMap<String, TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>>)spaces.get(space)) == null) {
                    pages = new TreeMap<String, TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>>();
                    spaces.put(space, pages);
                }
                if ((locales = (TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>)pages.get(page)) == null) {
                    locales = new TreeMap<String, DocumentsModifiedDuringDistributionListener.DocumentStatus>();
                    pages.put(page, locales);
                }
                locales.put(locale, document.getValue());
            }
        }
        return tree;
    }

    public void setProperty(String key, Object value) {
        DistributionJob job;
        if (this.authorization.hasAccess(Right.PROGRAM) && (job = this.distributionManager.getCurrentDistributionJob()) != null) {
            job.setProperty(key, value);
        }
    }

    public Object getProperty(String key) {
        DistributionJob job;
        if (this.authorization.hasAccess(Right.PROGRAM) && (job = this.distributionManager.getCurrentDistributionJob()) != null) {
            return job.getProperty(key);
        }
        return null;
    }

    public void removeProperty(String key) {
        DistributionJob job;
        if (this.authorization.hasAccess(Right.PROGRAM) && (job = this.distributionManager.getCurrentDistributionJob()) != null) {
            job.removeProperty(key);
        }
    }
}

