/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal.observation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.events.EventStreamAddedEvent;
import org.xwiki.eventstream.events.EventStreamDeletedEvent;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
@Singleton
@Named(value="eventstreamevent")
public class EventStreamEventConverter
extends AbstractEventConverter {
    private static final Set<Class<? extends org.xwiki.observation.event.Event>> EVENTS = new HashSet<Class>(Arrays.asList(EventStreamAddedEvent.class, EventStreamDeletedEvent.class));
    @Inject
    private EventStore store;
    @Inject
    private Logger logger;

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializeEvent((Event)localEvent.getSource()));
            return true;
        }
        return false;
    }

    private Serializable serializeEvent(Event local) {
        if (local != null) {
            return local.getId();
        }
        return null;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            try {
                localEvent.setEvent((org.xwiki.observation.event.Event)remoteEvent.getEvent());
                localEvent.setSource((Object)this.unserializeEvent(remoteEvent.getSource()));
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
        }
        return false;
    }

    private Event unserializeEvent(Serializable remote) throws EventStreamException {
        if (remote instanceof String) {
            return this.store.getEvent((String)((Object)remote)).orElse(null);
        }
        return null;
    }
}

