/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal.observation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.internal.events.EventStatusAddOrUpdatedEvent;
import org.xwiki.eventstream.internal.events.EventStatusDeletedEvent;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
@Singleton
@Named(value="eventstatus")
public class EventStatusEventConverter
extends AbstractEventConverter {
    private static final Set<Class<? extends org.xwiki.observation.event.Event>> EVENTS = new HashSet<Class>(Arrays.asList(EventStatusAddOrUpdatedEvent.class, EventStatusDeletedEvent.class));
    private static final String PROP_EVENTID = "eventId";
    private static final String PROP_ENTITYID = "entityId";
    private static final String PROP_ISREAD = "isRead";
    @Inject
    private EventStore store;
    @Inject
    private Logger logger;

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializeEventStatus((EventStatus)localEvent.getSource()));
            return true;
        }
        return false;
    }

    private Serializable serializeEventStatus(EventStatus local) {
        Serializable remote = null;
        if (local != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PROP_EVENTID, local.getEvent().getId());
            map.put(PROP_ENTITYID, local.getEntityId());
            map.put(PROP_ISREAD, local.isRead());
            remote = map;
        }
        return remote;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            try {
                localEvent.setEvent((org.xwiki.observation.event.Event)remoteEvent.getEvent());
                localEvent.setSource(this.unserializeEventStatus(remoteEvent.getSource()));
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
        }
        return false;
    }

    private Object unserializeEventStatus(Serializable remote) throws EventStreamException {
        if (remote instanceof Map) {
            Map map = (Map)((Object)remote);
            String eventId = (String)map.get(PROP_EVENTID);
            Optional event = this.store.getEvent(eventId);
            if (event.isPresent()) {
                return new DefaultEventStatus((Event)event.get(), (String)map.get(PROP_ENTITYID), ((Boolean)map.get(PROP_ISREAD)).booleanValue());
            }
            this.logger.warn("Could not find any event corresponding to the remote event with id [{}]", (Object)eventId);
        }
        return null;
    }
}

